/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.standard.FigureException;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.application.IllegalCompilerException;
import de.renew.application.NoSimulationException;
import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulationRunningException;
import de.renew.application.SimulatorExtension;
import de.renew.application.SimulatorExtensionAdapter;
import de.renew.application.SimulatorPlugin;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.gui.BindingSelectionFrame;
import de.renew.gui.Breakpoint;
import de.renew.gui.BreakpointHitEvent;
import de.renew.gui.BreakpointHitListener;
import de.renew.gui.BreakpointManager;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.CPNSimulation;
import de.renew.gui.ConfigureSimulationCommand;
import de.renew.gui.FigureExceptionFactory;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InstanceFigure;
import de.renew.gui.ModeReplacement;
import de.renew.gui.OpenServerFrameCommand;
import de.renew.gui.TransitionInstanceFigure;
import de.renew.io.SimulationStateFileFilter;
import de.renew.net.IDRegistry;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.NetNotFoundException;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import de.renew.remote.NetAccessor;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.remote.TransitionAccessor;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.remote.TransitionInstanceAccessorImpl;
import de.renew.shadow.SyntaxException;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class SimulationMenuCreator {
    public static Logger logger = Logger.getLogger(SimulationMenuCreator.class);
    private static final Lock lock = new ReentrantLock();

    public Collection<JMenuItem> createMenus(BreakpointManager breakpointManager) {
        MenuManager.SeparatorFactory separatorFactory = new MenuManager.SeparatorFactory("de.renew.gui.simulation");
        Vector<JMenuItem> vector = new Vector<JMenuItem>();
        vector.add(DrawApplication.createMenuItem((String)"Run simulation", (int)82, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                lock.lock();
                GuiPlugin guiPlugin = GuiPlugin.getCurrent();
                if (!ModeReplacement.getInstance().getSimulation().isSimulationActive()) {
                    ModeReplacement.getInstance().getSimulation().getSimulatorPlugin().addExtension((SimulatorExtension)new SimulatorExtensionAdapter(){

                        public void simulationSetup(SimulationEnvironment simulationEnvironment) {
                            ModeReplacement.getInstance().getSimulation().simulationRun();
                            ModeReplacement.getInstance().getSimulation().getSimulatorPlugin().removeExtension((SimulatorExtension)this);
                        }
                    });
                    SimulationMenuCreator.this.initSimulation();
                } else {
                    guiPlugin.showStatus("Simulation running.");
                    ModeReplacement.getInstance().getSimulation().simulationRun();
                }
                lock.unlock();
            }
        }));
        vector.add(DrawApplication.createMenuItem((String)"Simulation Step", (int)73, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationThreadPool.getCurrent().execute((Runnable)new Thread(){

                    @Override
                    public void run() {
                        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
                        if (!ModeReplacement.getInstance().getSimulation().isSimulationActive()) {
                            SimulationMenuCreator.this.initSimulation();
                        } else {
                            guiPlugin.showStatus("Searching for a binding...");
                            int n = ModeReplacement.getInstance().getSimulation().simulationStep();
                            switch (n) {
                                case 0: {
                                    if (ModeReplacement.getInstance().getSimulation().isSimulationActive()) {
                                        guiPlugin.showStatus("Simulation halted.");
                                        break;
                                    }
                                    guiPlugin.showStatus("Simulation terminated.");
                                    break;
                                }
                                case 1: {
                                    guiPlugin.showStatus("Simulation step completed.");
                                    break;
                                }
                                case 2: {
                                    guiPlugin.showStatus("Simulation step completed. No more enabled bindings.");
                                    break;
                                }
                                case 3: {
                                    guiPlugin.showStatus("No enabled bindings found.");
                                    break;
                                }
                                case 4: {
                                    guiPlugin.showStatus("No more enabled bindings.");
                                }
                            }
                        }
                    }
                });
            }
        }));
        vector.add((JMenuItem)new CommandMenuItem(new Command("Simulation Net Step"){

            public void execute() {
                SimulationThreadPool.getCurrent().execute((Runnable)new Thread(){
                    private HitListener listener;

                    @Override
                    public void run() {
                        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
                        if (!ModeReplacement.getInstance().getSimulation().isSimulationActive()) {
                            SimulationMenuCreator.this.initSimulation();
                        } else {
                            BreakpointManager breakpointManager = ModeReplacement.getInstance().getSimulation().getBreakpointManager();
                            DrawingView drawingView = DrawPlugin.getCurrent().getDrawingEditor().view();
                            Drawing drawing = drawingView.drawing();
                            if (drawing instanceof CPNInstanceDrawing) {
                                FigureEnumeration figureEnumeration = drawing.figures();
                                Vector<Breakpoint> vector = new Vector<Breakpoint>();
                                while (figureEnumeration.hasMoreElements()) {
                                    Object object = figureEnumeration.nextElement();
                                    if (!(object instanceof TransitionInstanceFigure)) continue;
                                    TransitionInstanceFigure transitionInstanceFigure = (TransitionInstanceFigure)object;
                                    TransitionInstanceAccessor transitionInstanceAccessor = transitionInstanceFigure.getInstance();
                                    if (!(transitionInstanceAccessor instanceof TransitionInstanceAccessorImpl)) {
                                        GuiPlugin.getCurrent().showStatus("The net step feature is only enabled for local simulations.");
                                        return;
                                    }
                                    TransitionInstance transitionInstance = ((TransitionInstanceAccessorImpl)transitionInstanceAccessor).getTransitionInstance();
                                    vector.add(breakpointManager.createTransitionInstanceBreakpoint(transitionInstance, 2));
                                }
                                this.listener = new HitListener(vector);
                                breakpointManager.addBreakpointHitListener(this.listener);
                                guiPlugin.showStatus("waiting for next transition firing in this net instance...");
                                ModeReplacement.getInstance().getSimulation().simulationRun();
                            } else {
                                GuiPlugin.getCurrent().showStatus("A net instance drawing must be selected.");
                            }
                        }
                    }

                    class HitListener
                    implements BreakpointHitListener {
                        private Vector<Breakpoint> bps;

                        protected HitListener(Vector<Breakpoint> vector) {
                            this.bps = vector;
                        }

                        @Override
                        public void hitBreakpoint(BreakpointHitEvent breakpointHitEvent) {
                            if (this.bps.contains(breakpointHitEvent.getBp())) {
                                breakpointHitEvent.consume();
                                if (ModeReplacement.getInstance().getSimulation().isSimulationActive()) {
                                    GuiPlugin.getCurrent().showStatus("Simulation halted.");
                                } else {
                                    GuiPlugin.getCurrent().showStatus("Simulation terminated.");
                                }
                                BreakpointManager breakpointManager = ModeReplacement.getInstance().getSimulation().getBreakpointManager();
                                for (Breakpoint breakpoint : this.bps) {
                                    breakpointManager.deleteBreakpoint(breakpoint);
                                }
                                breakpointManager.removeBreakpointHitListener(listener);
                            }
                        }
                    }
                });
            }
        }, 73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 64));
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            n += 64;
        }
        vector.add((JMenuItem)new CommandMenuItem(new Command("Halt simulation"){

            public boolean isExecutable() {
                if (!super.isExecutable()) {
                    return false;
                }
                return ModeReplacement.getInstance().getSimulation().isSimulationActive();
            }

            public void execute() {
                ModeReplacement.getInstance().getSimulation().simulationStop();
                GuiPlugin.getCurrent().showStatus("Simulation halted.");
            }
        }, 72, n));
        vector.add((JMenuItem)new CommandMenuItem(new Command("Terminate simulation"){

            public boolean isExecutable() {
                if (!super.isExecutable()) {
                    return false;
                }
                return ModeReplacement.getInstance().getSimulation().isSimulationActive();
            }

            public void execute() {
                ModeReplacement.getInstance().getSimulation().simulationTerminate();
            }
        }, 84));
        vector.add(separatorFactory.createSeparator());
        vector.add((JMenuItem)new CommandMenuItem((Command)new ConfigureSimulationCommand("Configure Simulation...")));
        vector.add(breakpointManager.getSimulationMenu());
        vector.add(separatorFactory.createSeparator());
        vector.add((JMenuItem)new CommandMenuItem(new Command("Save simulation state..."){

            public boolean isExecutable() {
                if (!super.isExecutable()) {
                    return false;
                }
                return ModeReplacement.getInstance().getSimulation().isSimulationActive();
            }

            public void execute() {
                SimulationMenuCreator.this.promptSaveSimulationState();
            }
        }));
        vector.add((JMenuItem)new CommandMenuItem(new Command("Load simulation state..."){

            public void execute() {
                SimulationMenuCreator.this.promptLoadSimulationState();
            }
        }));
        vector.add(separatorFactory.createSeparator());
        vector.add((JMenuItem)new CommandMenuItem((Command)new OpenServerFrameCommand("Remote Server...")));
        return vector;
    }

    void initSimulation() {
        SimulatorPlugin.lock.lock();
        try {
            SimulationThreadPool.getNew().execute(new Runnable(){

                @Override
                public void run() {
                    final GuiPlugin guiPlugin = GuiPlugin.getCurrent();
                    final CPNApplication cPNApplication = guiPlugin.getGui();
                    cPNApplication.showStatus("Starting Simulation ...");
                    if (!(cPNApplication.drawing() instanceof CPNDrawing)) {
                        cPNApplication.showStatus("Cannot start new simulation with this drawing! Please activate a net window.");
                        return;
                    }
                    String string = GuiPlugin.getCurrent().getDrawingEditor().drawing().getName();
                    try {
                        final NetInstanceAccessor netInstanceAccessor = SimulationMenuCreator.this.getSimulation().initSimulation(string);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (netInstanceAccessor != null) {
                                    cPNApplication.openInstanceDrawing(netInstanceAccessor);
                                    if (SimulationMenuCreator.this.getSimulation().isSimulationActive()) {
                                        cPNApplication.showStatus("Simulation initialized.");
                                    } else {
                                        cPNApplication.showStatus("Simulation initialized. No enabled bindings.");
                                    }
                                } else {
                                    cPNApplication.showStatus("The simulation could not be initialized.");
                                }
                            }
                        });
                    }
                    catch (SyntaxException syntaxException) {
                        logger.debug((Object)syntaxException.getMessage(), (Throwable)syntaxException);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                guiPlugin.processSyntaxException(FigureExceptionFactory.createFigureException(syntaxException), true);
                            }
                        });
                    }
                    catch (NetNotFoundException netNotFoundException) {
                        logger.warn((Object)netNotFoundException.getMessage(), (Throwable)netNotFoundException);
                        guiPlugin.showStatus("Net \"" + string + "\" not found although the drawing exists (should not happen).");
                    }
                    catch (IllegalCompilerException illegalCompilerException) {
                        logger.warn((Object)illegalCompilerException.getMessage(), (Throwable)illegalCompilerException);
                        guiPlugin.showStatus("No compiler selected. Please choose a formalism.");
                    }
                    catch (NoSimulationException noSimulationException) {
                        logger.debug((Object)noSimulationException.getMessage(), (Throwable)noSimulationException);
                        guiPlugin.showStatus("Simulation aborted during initialization.");
                    }
                    catch (RuntimeException runtimeException) {
                        logger.warn((Object)("Simulation initialization failed: " + runtimeException.toString()), (Throwable)runtimeException);
                        guiPlugin.showStatus("Simulation initialization failed: " + runtimeException.getMessage());
                    }
                    catch (Error error) {
                        logger.error((Object)("Simulation initialization failed: " + error.toString()), (Throwable)error);
                        guiPlugin.showStatus("Simulation initialization failed: " + error.toString());
                    }
                }
            });
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
    }

    void promptLoadSimulationState() {
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        CPNApplication cPNApplication = guiPlugin.getGui();
        File file = DrawPlugin.getCurrent().getIOHelper().getLoadPath(null, (FileFilter)((Object)new SimulationStateFileFilter()));
        if (file != null) {
            BindingSelectionFrame.close();
            cPNApplication.closeAllSimulationDrawings();
            Object object = null;
            ObjectInput objectInput = null;
            try {
                GuiPlugin.getCurrent().showStatus("Importing " + String.valueOf(file) + " ...");
                FileInputStream fileInputStream = new FileInputStream(file);
                objectInput = new RenewObjectInputStream((InputStream)fileInputStream);
                ModeReplacement.getInstance().getSimulation().loadState(objectInput);
                guiPlugin.showStatus("Imported " + String.valueOf(file) + ".");
            }
            catch (SimulationRunningException simulationRunningException) {
                object = "Cannot load state into running simulation";
            }
            catch (ObjectStreamException objectStreamException) {
                object = "File " + String.valueOf(file) + " is corrupted or does not contain state information.";
                logger.error((Object)objectStreamException.getMessage(), (Throwable)objectStreamException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = "File " + String.valueOf(file) + " refers to java classes which are currently not available.";
                logger.error((Object)classNotFoundException.getMessage(), (Throwable)classNotFoundException);
            }
            catch (IOException iOException) {
                object = "Problem occured while reading file " + String.valueOf(file) + ":" + String.valueOf(iOException);
            }
            catch (StackOverflowError stackOverflowError) {
                object = "StackOverflowError: Probably the recursion in Java's serialization mechanism went too deep.\nIf you are using JDK 1.1, try setting the java options  -ss... and/or -oss... to increase native and java stack sizes. Setting -ss1m was appropriate for us.";
            }
            try {
                if (objectInput != null) {
                    objectInput.close();
                }
                if (object == null) {
                    object = "Simulation state restored from " + String.valueOf(file) + ".";
                }
            }
            catch (StreamCorruptedException streamCorruptedException) {
                if (object == null) {
                    object = "Problem occurred while reading file " + String.valueOf(file) + ", but all relevant information was already read. Perhaps the simulation state is valid anyway.";
                    logger.error((Object)("Exception while closing: " + String.valueOf(streamCorruptedException)));
                }
            }
            catch (Exception exception) {
                if (object == null) {
                    object = "Problem occurred while reading file " + String.valueOf(file) + ", but all relevant information was already read. Perhaps the simulation state is valid anyway.";
                }
                logger.error((Object)("Exception while closing: " + String.valueOf(exception)));
            }
            guiPlugin.showStatus((String)object);
            logger.error(object);
        }
    }

    void promptSaveSimulationState() {
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (!ModeReplacement.getInstance().getSimulation().isSimulationActive()) {
            guiPlugin.showStatus("Need running simulation to save state.");
        } else {
            File file = DrawPlugin.getCurrent().getIOHelper().getSavePath(null, (SimpleFileFilter)new SimulationStateFileFilter());
            if (file != null) {
                Stack stack;
                Object object;
                block13: {
                    String string = file.getAbsolutePath();
                    object = null;
                    stack = null;
                    RenewObjectOutputStream renewObjectOutputStream = null;
                    try {
                        guiPlugin.showStatus("Exporting " + string + " ...");
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        renewObjectOutputStream = new RenewObjectOutputStream((OutputStream)fileOutputStream);
                        ModeReplacement.getInstance().getSimulation().saveState((ObjectOutput)renewObjectOutputStream);
                        guiPlugin.showStatus("Exported " + string + ".");
                    }
                    catch (NotSerializableException notSerializableException) {
                        object = "Some object or class is not serializable: " + notSerializableException.getMessage() + ".\nWriting of file " + string + " aborted.";
                        stack = renewObjectOutputStream != null ? renewObjectOutputStream.getDomainTrace() : null;
                        logger.debug((Object)notSerializableException.getMessage(), (Throwable)notSerializableException);
                    }
                    catch (Exception exception) {
                        object = "Problem encountered while writing file " + string + ": " + String.valueOf(exception);
                        logger.debug((Object)exception.getMessage(), (Throwable)exception);
                    }
                    catch (StackOverflowError stackOverflowError) {
                        object = "StackOverflowError: Probably the recursion in Java's serialization mechanism went too deep.\nIf you are using JDK 1.1, try setting the java options  -ss... and/or -oss... to increase native and java stack sizes. Setting -ss1m was appropriate for us.";
                        logger.debug((Object)stackOverflowError.getMessage(), (Throwable)stackOverflowError);
                    }
                    try {
                        if (renewObjectOutputStream != null) {
                            renewObjectOutputStream.close();
                        }
                        if (object == null) {
                            object = "Simulation state saved to " + string + ".";
                        }
                    }
                    catch (Exception exception) {
                        if (object != null) break block13;
                        object = "Problem encountered while closing file " + string + ": " + String.valueOf(exception);
                    }
                }
                if (stack != null) {
                    this.displaySaveSimError(stack, (String)object);
                } else {
                    guiPlugin.showStatus((String)object);
                    logger.error(object);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void displaySaveSimError(Stack<Object> stack, String object) {
        try {
            Object object2;
            Object object3;
            boolean bl;
            String string;
            CPNDrawing cPNDrawing;
            Object object4;
            String string2;
            Object object5;
            int n;
            NetInstanceAccessor netInstanceAccessor;
            NetAccessor netAccessor;
            GuiPlugin guiPlugin;
            block30: {
                guiPlugin = GuiPlugin.getCurrent();
                netAccessor = null;
                netInstanceAccessor = null;
                n = 0;
                object5 = null;
                string2 = null;
                object4 = null;
                cPNDrawing = null;
                string = null;
                bl = false;
                try {
                    object4 = stack.peek();
                    object3 = RemotePlugin.getInstance();
                    if (object4 instanceof PlaceInstance) {
                        object2 = object3.wrapInstance((PlaceInstance)object4);
                        n = object2.getPlace().getID().getFigureID();
                        netInstanceAccessor = object2.getNetInstance();
                        netAccessor = netInstanceAccessor.getNet();
                        break block30;
                    }
                    if (object4 instanceof TransitionInstance) {
                        object2 = object3.wrapInstance((TransitionInstance)object4);
                        n = object2.getTransition().getID().getFigureID();
                        netInstanceAccessor = object2.getNetInstance();
                        netAccessor = netInstanceAccessor.getNet();
                        break block30;
                    }
                    if (object4 instanceof Place) {
                        object5 = "place " + String.valueOf(object4);
                        n = ((Place)object4).getID().getFigureID();
                        break block30;
                    }
                    if (object4 instanceof TransitionAccessor) {
                        object5 = "transition " + String.valueOf(object4);
                        n = ((Transition)object4).getID().getFigureID();
                        break block30;
                    }
                    if (object4 instanceof Net) {
                        object5 = "net " + String.valueOf(object4);
                        netAccessor = object3.wrapNet((Net)object4);
                        break block30;
                    }
                    if (object4 instanceof NetInstance) {
                        object5 = "net instance " + String.valueOf(object4);
                        netInstanceAccessor = object3.wrapInstance((NetInstance)object4);
                        netAccessor = netInstanceAccessor.getNet();
                        break block30;
                    }
                    if (object4 instanceof IDRegistry) {
                        object5 = "a token ID registry";
                        break block30;
                    }
                    if (object4 == SimulatorPlugin.class) {
                        object5 = "instance drawings";
                        break block30;
                    }
                    if (object4 == Net.class) {
                        object5 = "compiled nets";
                        break block30;
                    }
                    if (object4 == SearchQueue.class) {
                        object5 = "search queue entries";
                        if (((String)object).indexOf("de.renew.call.SynchronisationRequest") >= 0) {
                            string2 = "You tried to save the simulation state while a Java call to a net method was still active. Wait until all methods have completed.";
                        }
                        break block30;
                    }
                    object5 = "(DON'T KNOW - TRACE CONTAINS OBJECT OF UNEXPECTED TYPE: " + object4.getClass().getName() + ")";
                }
                catch (EmptyStackException emptyStackException) {
                    object5 = "(DON'T KNOW - TRACE IS EMPTY!?)";
                }
                catch (NoSimulationException noSimulationException) {
                    object5 = "(DON'T KNOW - NO LOCAL SIMULATION RU)";
                }
            }
            if (object5 == null) {
                string = netAccessor != null ? netAccessor.getName() : null;
                object = (String)object + "\nThe problem lies around net element " + String.valueOf(object4) + ".";
                cPNDrawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing(string);
                bl = true;
            } else {
                object = string2 == null ? (String)object + "\nDid you try to save a state while the simulation was running (concurrent transition firing or binding calculation is not allowed)?" : (String)object + "\n" + string2;
                object = (String)object + "\nThe problem manifested itself while writing " + (String)object5 + ".";
                bl = true;
            }
            if (bl) {
                object = (String)object + "\nSerialization trace:";
                try {
                    while (!stack.isEmpty()) {
                        object4 = stack.pop();
                        object = (String)object + "\n    " + String.valueOf(object4);
                        if (netAccessor != null || netInstanceAccessor != null) continue;
                        try {
                            object3 = RemotePlugin.getInstance();
                            if (object4 instanceof Net) {
                                netAccessor = object3.wrapNet((Net)object4);
                                continue;
                            }
                            if (!(object4 instanceof NetInstance)) continue;
                            netInstanceAccessor = object3.wrapInstance((NetInstance)object4);
                            netAccessor = netInstanceAccessor.getNet();
                        }
                        catch (NoSimulationException noSimulationException) {}
                    }
                }
                catch (EmptyStackException emptyStackException) {
                    // empty catch block
                }
            }
            if (object5 == null) {
                if (cPNDrawing == null) {
                    guiPlugin.showStatus((String)object);
                    logger.error(object);
                    logger.error((Object)("Sorry, cannot show the location of the problem because net " + string + " is not loaded."));
                    return;
                }
                GuiPlugin.getCurrent().getGui().openInstanceDrawing(netInstanceAccessor);
                object3 = CPNInstanceDrawing.getInstanceDrawing(netInstanceAccessor);
                object2 = cPNDrawing.getFigureWithID(n);
                InstanceFigure instanceFigure = ((CPNInstanceDrawing)((Object)object3)).getInstanceFigure((Figure)object2);
                guiPlugin.showStatus((String)object);
                logger.error(object);
                GuiPlugin.getCurrent().processFigureException(new FigureException("Renew: Save simulation error", (String)object, (Drawing)object3, (Figure)instanceFigure), false);
                return;
            }
            guiPlugin.showStatus((String)object);
            logger.error(object);
            if (netAccessor == null) return;
            if (n == 0) return;
            cPNDrawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing(netAccessor.getName());
            if (cPNDrawing == null) return;
            object3 = cPNDrawing.getFigureWithID(n);
            if (object3 == null) return;
            if (netInstanceAccessor == null) {
                guiPlugin.processFigureException(new FigureException("Renew: Save simulation error", (String)object, (Drawing)cPNDrawing, (Figure)object3), false);
                return;
            }
            try {
                object2 = CPNInstanceDrawing.getInstanceDrawing(netInstanceAccessor);
                guiPlugin.processFigureException(new FigureException("Renew: Save simulation error", (String)object, (Drawing)object2, (Figure)object3), false);
                return;
            }
            catch (RemoteException remoteException) {
                logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
                JOptionPane.showMessageDialog(null, "A problem occurred: " + String.valueOf(remoteException) + "\nSee the console for details.", "Renew", 0);
                return;
            }
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            JOptionPane.showMessageDialog(null, "A problem occurred: " + String.valueOf(remoteException) + "\nSee the console for details.", "Renew", 0);
        }
    }

    protected CPNSimulation getSimulation() {
        return ModeReplacement.getInstance().getSimulation();
    }
}

