/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging;

import de.renew.logging.CliColor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class PatternLayout
extends org.apache.log4j.PatternLayout {
    private static final SimpleDateFormat DATE_FORMAT;
    private static final HashMap<Level, CliColor> LEVELS;

    public static String leftPad(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n);
        }
        if (string.length() < n) {
            StringBuilder stringBuilder = new StringBuilder(string);
            for (int i = string.length(); i < n; ++i) {
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public String format(LoggingEvent loggingEvent) {
        return String.format("%s %s %s %s\n", DATE_FORMAT.format(new Date()), this.formatLevel(loggingEvent), this.formatLocationInfo(loggingEvent), this.formatMessage(loggingEvent));
    }

    private String formatLevel(LoggingEvent loggingEvent) {
        Level level = loggingEvent.getLevel();
        String string = PatternLayout.leftPad(level.toString(), 5);
        CliColor cliColor = LEVELS.get(level);
        if (cliColor == null) {
            return CliColor.color(string, CliColor.BOLD);
        }
        return CliColor.color(string, CliColor.BOLD, cliColor);
    }

    private String formatLocationInfo(LoggingEvent loggingEvent) {
        LocationInfo locationInfo = loggingEvent.getLocationInformation();
        String string = locationInfo.getLineNumber();
        String string2 = locationInfo.getClassName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        return "[\u001b[0;33m" + string2 + ":" + string + "\u001b[m]";
    }

    private String formatMessage(LoggingEvent loggingEvent) {
        if (loggingEvent.getMessage() == null) {
            return "";
        }
        return loggingEvent.getMessage().toString();
    }

    static {
        LEVELS = new HashMap();
        LEVELS.put(Level.TRACE, CliColor.BLUE);
        LEVELS.put(Level.DEBUG, CliColor.CYAN);
        LEVELS.put(Level.INFO, CliColor.GREEN);
        LEVELS.put(Level.WARN, CliColor.YELLOW);
        LEVELS.put(Level.ERROR, CliColor.RED);
        LEVELS.put(Level.FATAL, CliColor.RED);
        DATE_FORMAT = new SimpleDateFormat("HH:mm:ss,SSS");
    }
}

