/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.ccpn;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.application.SimulatorPlugin;
import de.renew.engine.simulator.CCPNSimulation;
import de.renew.engine.simulator.CurrySimulator;
import de.renew.formalism.FormalismChangeListener;
import de.renew.formalism.FormalismPlugin;
import de.renew.formalism.ccpn.CurryNetCompiler;
import de.renew.formalism.ccpn.CurryReachabilityGraphCommand;
import de.renew.gui.CPNSimulation;
import de.renew.gui.ModeReplacement;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.shadow.ShadowCompilerFactory;
import java.net.URL;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class CCPNPlugin
extends PluginAdapter
implements FormalismChangeListener {
    public static Logger logger = Logger.getLogger(CCPNPlugin.class);
    public static final String CCPN_COMPILER = "Curry Net Compiler";
    public static final String DEFAULT_SIMULATOR_CLASS = CurrySimulator.class.getName();
    public static final String CCPN_LOCATION_PROPERTY = "de.renew.formalism.ccpn.ccpnbin";
    private static String ccpnLocation;
    private final CommandMenuItem _menuItem = new CommandMenuItem((Command)new CurryReachabilityGraphCommand());
    private String previousSimulatorClass;

    public CCPNPlugin(URL uRL) throws PluginException {
        super(uRL);
    }

    public CCPNPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
    }

    public void init() {
        ccpnLocation = SimulatorPlugin.getCurrent().getProperties().getProperty(CCPN_LOCATION_PROPERTY);
        if (ccpnLocation == null) {
            throw new RuntimeException("The ccpn binary location must be given by: -Dde.renew.formalism.ccpn.ccpnbin=path/to/ccpn");
        }
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        if (drawPlugin != null) {
            drawPlugin.getMenuManager().registerMenu("Tools", (JMenuItem)this._menuItem, "de.renew.rnrg");
        }
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        formalismPlugin.addFormalismChangeListener((FormalismChangeListener)this);
        formalismPlugin.addCompilerFactory(CCPN_COMPILER, (ShadowCompilerFactory)new CurryNetCompiler());
        super.init();
    }

    public boolean cleanup() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        if (drawPlugin != null) {
            drawPlugin.getMenuManager().unregisterMenu((JMenuItem)this._menuItem);
        }
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        formalismPlugin.removeFormalismChangeListener((FormalismChangeListener)this);
        formalismPlugin.removeCompilerFactory(CCPN_COMPILER);
        return true;
    }

    public void formalismChanged(String string, Object object, int n) {
        if (n == 2) {
            PluginProperties pluginProperties = SimulatorPlugin.getCurrent().getProperties();
            String string2 = pluginProperties.getProperty("de.renew.simulatorClass");
            ModeReplacement modeReplacement = ModeReplacement.getInstance();
            boolean bl = CCPN_COMPILER.equals(string);
            boolean bl2 = DEFAULT_SIMULATOR_CLASS.equals(string2);
            if (bl && !bl2) {
                this.previousSimulatorClass = string2;
                pluginProperties.setProperty("de.renew.simulatorClass", DEFAULT_SIMULATOR_CLASS);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(CCPNPlugin.class.getSimpleName() + ": Set simulator class property to " + DEFAULT_SIMULATOR_CLASS + ", because formalism Curry Net Compiler was chosen."));
                }
                modeReplacement.getSimulation().dispose();
                modeReplacement.setSimulation((CPNSimulation)new CCPNSimulation(modeReplacement.getDrawingLoader()));
            } else if (!bl && bl2) {
                modeReplacement.getSimulation().dispose();
                modeReplacement.setSimulation(null);
                if (this.previousSimulatorClass == null) {
                    pluginProperties.remove((Object)"de.renew.simulatorClass");
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(CCPNPlugin.class.getSimpleName() + ": Remove simulator class property set to " + DEFAULT_SIMULATOR_CLASS + ", because Curry Net Compiler is no longer the chosen formalism."));
                    }
                } else {
                    pluginProperties.setProperty("de.renew.simulatorClass", this.previousSimulatorClass);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(CCPNPlugin.class.getSimpleName() + ": Set simulator class property to old value " + this.previousSimulatorClass + " and remove the distribute extension, because Curry Net Compiler is no longer the chosen formalism."));
                    }
                }
            }
        }
    }

    public static String getCCPNLocation() {
        return ccpnLocation;
    }
}

