/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.simulator.CCPNProcess;
import de.renew.engine.simulator.Simulator;
import org.apache.log4j.Logger;

public class CurrySimulator
implements Simulator {
    public static Logger logger = Logger.getLogger(CurrySimulator.class);
    private CCPNProcess process;

    public CurrySimulator(boolean bl) {
        this();
    }

    public CurrySimulator() {
    }

    public boolean isActive() {
        return true;
    }

    private synchronized boolean processStopped() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(CurrySimulator.class.getSimpleName() + ": determining if CCPN process is stopped: " + String.valueOf(this.process)));
        }
        return this.process == null || this.process.stopped;
    }

    public synchronized void startRun() {
        if (!this.processStopped()) {
            this.process.continuousUpdate = true;
            this.process.run();
        }
    }

    public void setProcess(CCPNProcess cCPNProcess) {
        this.process = cCPNProcess;
    }

    public synchronized void stopRun() {
        if (!this.processStopped()) {
            this.process.continuousUpdate = false;
            this.process.stop();
        }
    }

    public synchronized void terminateRun() {
        if (this.process != null) {
            this.process.terminate();
            this.process = null;
        }
    }

    public synchronized int step() {
        if (this.processStopped()) {
            return 0;
        }
        if (this.process.continuousUpdate) {
            this.stopRun();
        } else {
            this.process.step();
        }
        return -1;
    }

    public void refresh() {
    }

    public boolean isSequential() {
        return false;
    }

    public StepIdentifier nextStepIdentifier() {
        return null;
    }

    public StepIdentifier currentStepIdentifier() {
        return null;
    }

    public long[] collectSimulationRunIds() {
        return null;
    }
}

