/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.application.NoSimulationException;
import de.renew.engine.simulator.CCPNProcess;
import de.renew.engine.simulator.CurrySimulator;
import de.renew.gui.CCPNDrawingHelper;
import de.renew.gui.CPNDrawingLoader;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.CPNSimulation;
import de.renew.net.NetInstance;
import de.renew.net.NetNotFoundException;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.shadow.SyntaxException;
import java.rmi.RemoteException;

public class CCPNSimulation
extends CPNSimulation {
    private boolean startRunning = false;
    private CCPNProcess process;

    public CCPNSimulation(CPNDrawingLoader cPNDrawingLoader) {
        super(false, cPNDrawingLoader);
    }

    public void simulationRun() {
        this.startRunning = true;
        super.simulationRun();
    }

    public void simulationTerminate() {
        this.startRunning = false;
        super.simulationTerminate();
    }

    public NetInstanceAccessor minimalInit(String string) throws SyntaxException, NetNotFoundException, NoSimulationException {
        CPNInstanceDrawing cPNInstanceDrawing;
        NetInstanceAccessorImpl netInstanceAccessorImpl = (NetInstanceAccessorImpl)super.initSimulation(string);
        try {
            cPNInstanceDrawing = CPNInstanceDrawing.getInstanceDrawing((NetInstanceAccessor)netInstanceAccessorImpl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        this.process = CCPNProcess.startProcess((NetInstance)netInstanceAccessorImpl.getObject(), CCPNDrawingHelper.extract(cPNInstanceDrawing));
        ((CurrySimulator)this.getSimulatorPlugin().getCurrentEnvironment().getSimulator()).setProcess(this.process);
        return netInstanceAccessorImpl;
    }

    public NetInstanceAccessor initSimulation(String string) throws SyntaxException, NetNotFoundException, NoSimulationException {
        NetInstanceAccessor netInstanceAccessor = this.minimalInit(string);
        if (this.startRunning) {
            this.process.continuousUpdate = true;
            this.process.run();
        } else {
            this.process.step();
        }
        return netInstanceAccessor;
    }

    public void requestReachGraph() {
        this.process.reachGraph();
    }
}

