/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.NullDrawingEditor;

public class SetLineWidthCommand
extends UndoableCommand {
    private int fWidth;

    public SetLineWidthCommand(String string, int n) {
        super(string);
        this.fWidth = n;
    }

    @Override
    protected boolean executeUndoable() {
        DrawingView drawingView = this.getEditor().view();
        FigureEnumeration figureEnumeration = drawingView.selectionElements();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.setAttribute("LineWidth", this.fWidth);
        }
        drawingView.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }
}

