/*
 * Decompiled with CFR 0.152.
 */
package de.renew.rnrg.gui;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.util.StorableInput;
import de.renew.gui.AnnealingGraphLayout;
import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;
import de.renew.rnrg.elements.Edge;
import de.renew.rnrg.elements.Graph;
import de.renew.rnrg.elements.InscribedEdge;
import de.renew.rnrg.elements.Node;
import de.renew.rnrg.gui.EdgeInscription;
import de.renew.rnrg.gui.ExploredNodeFigure;
import de.renew.rnrg.gui.UnexploredNodeFigure;
import java.awt.Color;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class GraphDrawing
extends StandardDrawing
implements LayoutableDrawing {
    public static Logger logger = Logger.getLogger(GraphDrawing.class);
    private static final long serialVersionUID = 0L;
    private static final int CONNECTION_LENGTH = 90;
    public static final int INSC_NOTHING = 0;
    public static final int INSC_ROOT = 1;
    public static final int INSC_ALL = 2;
    public static final int INSC_DEPTH = 3;
    public static final String[] INSC_MODES = new String[]{"Nothing", "State of Root Net Instance", "State of all Net Instances", "Depth"};

    public GraphDrawing() {
    }

    public GraphDrawing(Graph graph, int n) {
        this(graph.getNodes(), graph.getStartNode(), n);
    }

    public GraphDrawing(Collection<Node> collection, Node node, int n) {
        HashMap<Node, AttributeFigure> hashMap = new HashMap<Node, AttributeFigure>();
        for (Node node2 : collection) {
            this.addExploredFigure(node2, hashMap, n);
        }
        for (Node node2 : collection) {
            this.addEdges(node2, hashMap);
        }
        ((AttributeFigure)hashMap.get(node)).setFillColor(Color.RED);
        new AnnealingGraphLayout().annealingLayout((LayoutableDrawing)this);
    }

    private void addExploredFigure(Node node, Map<Node, AttributeFigure> map, int n) {
        ExploredNodeFigure exploredNodeFigure = new ExploredNodeFigure(node);
        map.put(node, (AttributeFigure)exploredNodeFigure);
        this.add((Figure)exploredNodeFigure);
        if (n != 0) {
            this.add((Figure)exploredNodeFigure.createTextFigure(n));
        }
    }

    private AttributeFigure addUnexploredFigure() {
        UnexploredNodeFigure unexploredNodeFigure = new UnexploredNodeFigure();
        this.add((Figure)unexploredNodeFigure);
        return unexploredNodeFigure;
    }

    private void addEdges(Node node, Map<Node, AttributeFigure> map) {
        Collection<Edge> collection = node.getEdges();
        for (Edge edge : collection) {
            Node node2 = edge.getTargetNode();
            AttributeFigure attributeFigure = node2 == null ? this.addUnexploredFigure() : map.get(node2);
            this.connect(map.get(node), attributeFigure, edge);
        }
    }

    private void connect(AttributeFigure attributeFigure, AttributeFigure attributeFigure2, Edge edge) {
        LineConnection lineConnection = new LineConnection(null, (LineDecoration)new ArrowTip(), "");
        lineConnection.startPoint(0, 0);
        lineConnection.endPoint(0, 0);
        lineConnection.connectStart(attributeFigure.connectorAt(attributeFigure.center()));
        lineConnection.connectEnd(attributeFigure2.connectorAt(attributeFigure2.center()));
        lineConnection.updateConnection();
        this.add((Figure)lineConnection);
        if (edge instanceof InscribedEdge) {
            EdgeInscription edgeInscription = new EdgeInscription((InscribedEdge)edge, (ParentFigure)lineConnection);
            this.add((Figure)edgeInscription);
        }
    }

    public synchronized void fillInGraph(GraphLayout graphLayout) {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure instanceof ExploredNodeFigure || figure instanceof UnexploredNodeFigure) {
                graphLayout.addNode(figure);
                continue;
            }
            if (!(figure instanceof ConnectionFigure)) continue;
            graphLayout.addEdge((ConnectionFigure)figure, 90);
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        int n = storableInput.readInt();
        this.fFigures = new Vector(n);
        for (int i = 0; i < n; ++i) {
            String string;
            try {
                Figure figure = (Figure)storableInput.readStorable();
                if (figure instanceof EdgeInscription && !this.fFigures.contains(string = ((EdgeInscription)figure).parent())) {
                    this.add((Figure)string);
                    ++i;
                }
                this.add(figure);
                continue;
            }
            catch (IOException iOException) {
                string = GraphDrawing.class.getSimpleName() + ": could not read in " + Figure.class.getSimpleName() + " object:";
                if (logger.isDebugEnabled()) {
                    logger.error((Object)string, (Throwable)iOException);
                    break;
                }
                logger.error((Object)(string + " " + String.valueOf(iOException)));
                break;
            }
        }
    }
}

