/*
 * Decompiled with CFR 0.152.
 */
package de.renew.rnrg.gui;

import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.gui.GuiPlugin;
import de.renew.gui.MultipleTokenFigure;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.remote.MarkingAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.ObjectAccessor;
import de.renew.rnrg.elements.Node;
import de.renew.rnrg.gui.Inscription;
import de.renew.util.Base64Coder;
import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ExploredNodeFigure
extends EllipseFigure {
    private static Logger logger = Logger.getLogger(ExploredNodeFigure.class);
    Node node;

    public ExploredNodeFigure() {
    }

    public ExploredNodeFigure(Node node) {
        super(new Point(0, 0), new Point(20, 20));
        this.setFillColor(Color.WHITE);
        this.node = node;
    }

    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (this.node != null) {
            NetInstance netInstance = this.node.getRootNetInstance();
            try {
                GuiPlugin.getCurrent().openInstanceDrawing((NetInstanceAccessor)new NetInstanceAccessorImpl(netInstance, null));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Net state seems to have been lost.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOException iOException = null;
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(this.node);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException == null) {
            storableOutput.writeString(Base64Coder.encode((byte[])byteArrayOutputStream.toByteArray()));
        } else {
            logger.warn((Object)(ExploredNodeFigure.class.getSimpleName() + ": could not serialize internal net state: "), (Throwable)iOException);
            storableOutput.writeString("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        String string = storableInput.readString();
        if (string == "") {
            logger.warn((Object)(ExploredNodeFigure.class.getSimpleName() + ": serialized internal net state is missing."));
        } else {
            byte[] byArray = Base64Coder.decode((String)string);
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));){
                this.node = (Node)objectInputStream.readObject();
            }
        }
    }

    private static void describePlaceInstance(StringBuffer stringBuffer, PlaceInstance placeInstance) {
        stringBuffer.append('{');
        try {
            MarkingAccessorImpl markingAccessorImpl = new MarkingAccessorImpl(placeInstance, null);
            int n = markingAccessorImpl.getDistinctTokenCount();
            for (int i = 0; i < n; ++i) {
                ObjectAccessor objectAccessor = markingAccessorImpl.getToken(i);
                int n2 = markingAccessorImpl.getTokenFreeCount(i);
                boolean bl = markingAccessorImpl.getTokenTested(i);
                stringBuffer.append(MultipleTokenFigure.getMultString((int)n2, (boolean)bl));
                stringBuffer.append(objectAccessor == null ? "null" : objectAccessor.asString());
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append('}');
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
        }
    }

    private static void describeNetInstance(StringBuffer stringBuffer, NetInstance netInstance) {
        ArrayList arrayList = new ArrayList(netInstance.getNet().places());
        Collections.sort(arrayList, new Comparator<Place>(){

            @Override
            public int compare(Place place, Place place2) {
                return place.getName().compareTo(place2.getName());
            }
        });
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Place place = (Place)iterator.next();
            stringBuffer.append(place.getName());
            stringBuffer.append('=');
            ExploredNodeFigure.describePlaceInstance(stringBuffer, netInstance.getInstance(place));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
    }

    private static String describeNode(StringBuffer stringBuffer, Node node) {
        NetInstance netInstance = node.getRootNetInstance();
        ArrayList<? extends NetInstance> arrayList = new ArrayList<NetInstance>(node.getNetInstances());
        Collections.sort(arrayList, new Comparator<NetInstance>(){

            @Override
            public int compare(NetInstance netInstance, NetInstance netInstance2) {
                return netInstance.getID().compareTo(netInstance2.getID());
            }
        });
        StringBuffer stringBuffer2 = new StringBuffer();
        ExploredNodeFigure.describeNetInstance(stringBuffer2, netInstance);
        stringBuffer.append(netInstance);
        stringBuffer.append(": ");
        stringBuffer.append(stringBuffer2);
        for (NetInstance netInstance2 : arrayList) {
            if (netInstance2 == netInstance) continue;
            stringBuffer.append('\n');
            stringBuffer.append(netInstance2);
            stringBuffer.append(": ");
            ExploredNodeFigure.describeNetInstance(stringBuffer, netInstance2);
        }
        return stringBuffer2.toString();
    }

    private TextFigure createTextFigure(String string) {
        TextFigure textFigure = new TextFigure(string);
        textFigure.setReadOnly(true);
        textFigure.setParent((ParentFigure)this);
        this.addToContainer((FigureChangeListener)textFigure);
        return textFigure;
    }

    public TextFigure createTextFigure(int n) {
        if (n == 3) {
            return this.createTextFigure(String.valueOf(this.node.getDepth()));
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = ExploredNodeFigure.describeNode(stringBuffer, this.node);
        return new Inscription(string, stringBuffer.toString(), n == 2, (ParentFigure)this);
    }
}

