/*
  File: SimpleTest.java

  Originally written by Doug Lea and released into the public domain. 
  Thanks for the assistance and support of Sun Microsystems Labs, Agorics 
  Inc, Loral, and everyone contributing, testing, and using this code.

  History:
  Date     Who                What
  24Sep95  dl@cs.oswego.edu   Create from collections.java  working file

*/
  
package collections;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Random;

/**
 *
 *
 * Just the collection of very simple tests
 *
 * @author Doug Lea
 * @version 0.91
 *
 * <P> For an introduction to this package see <A HREF="index.html"> Overview </A>.
**/

class SimpleTest {

//  static final int size = 100;
  static final int size = 30;

  static Random rng = new Random();

  static Integer nums[];

  static void randomPermute(Object a[]) {

    for (int i = 1; i < a.length; ++i) {
      int j = (rng.nextInt() & 0x7FFFFFFF) % (i + 1);
      Object tmp = a[i]; a[i] = a[j]; a[j] = tmp;
    }
  }

  static void t2(UpdatableSet s) {
    
    Enumeration e = new ArrayEnumeration(nums);

    while (e.hasMoreElements()) {
      Object v = e.nextElement();
      try {
        s.include(v);
      }
      catch (IllegalElementException ex) {
        if (s.canInclude(v)) System.out.println("?? can't include" + v);
      }
    }
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) {
      Object v = e.nextElement();
      if (s.canInclude(v))
        s.include(v);
    }
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    for (int i = 0; i < size/2; ++i) s.exclude(e.nextElement());
    System.out.println("...");

    s.replaceAllOf(nums[size-1], new Integer(999));
    System.out.println("...");

    System.out.println(s);
    System.out.println("...");

    System.out.println("");
    while (!s.isEmpty()) {
      System.out.print(s.take() + " ");
    }
    System.out.println("");
  }



  static void t4(UpdatableBag s) {

    Enumeration e = new ArrayEnumeration(nums);

    while (e.hasMoreElements()) s.addIfAbsent(e.nextElement());
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) s.addIfAbsent(e.nextElement());
    System.out.println("...");


    e = new ArrayEnumeration(nums);
    for (int i = 0; i < size/2; ++i) s.exclude(e.nextElement());
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) s.add(e.nextElement());
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) s.add(e.nextElement());
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    for (int i = size/2 + 1; i < size; ++i) s.removeOneOf(e.nextElement());
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    for (int i = size/2 + 1; i < size; ++i) s.exclude(e.nextElement());
    System.out.println("...");

    s.replaceOneOf(nums[size-1], new Integer(999));
    System.out.println("...");
    s.replaceAllOf(nums[0], new Integer(9999));
    System.out.println("...");

    System.out.println(s);
    System.out.println("...");

    System.out.println("");
    while (!s.isEmpty()) {
      System.out.print(s.take() + " ");
    }
    System.out.println("");

  }

  static void t6(UpdatableSeq s) {

    Enumeration e = new ArrayEnumeration(nums);

    s.appendElements(e);
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    s.prependElements(e);
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    s.insertElementsAt(s.size()/2, e);
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    for (int i = 0; i < size/2; ++i) s.exclude(e.nextElement());
    System.out.println("...");

    int k = 0;
    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) s.insertAt(k++, e.nextElement());
    System.out.println("...");

    for (int i = 0; i < size/4; ++i) s.removeAt(i);
    System.out.println("...");

    for (int i = size * 3 / 4; i < size; ++i) s.replaceAt(i, nums[i]);
    System.out.println("...");

    for (int i = 0; i < size/4; ++i) s.insertFirst(nums[i]);
    System.out.println("...");

    for (int i = 0; i < size/4; ++i) s.removeFirst();
    System.out.println("...");

    for (int i = 0; i < size/4; ++i) s.replaceFirst(nums[i]);
    System.out.println("...");


    for (int i = 0; i < size/4; ++i) s.insertLast(nums[i]);
    System.out.println("...");

    for (int i = 0; i < size/4; ++i) s.removeLast();
    System.out.println("...");

    for (int i = 0; i < size/4; ++i) s.replaceLast(nums[i]);
    System.out.println("...");

    s.removeFromTo(s.size()/4, s.size()/2);
    System.out.println("...");

    s.replaceOneOf(s.at(1), new Integer(999));
    System.out.println("...");
    s.replaceAllOf(s.at(2), new Integer(-9999));
    System.out.println("...");

    System.out.println(s);
    System.out.println("...");

    UpdatableSeq t = (UpdatableSeq)(s.subseq(0, s.size()/2));
    System.out.println("...");

    if (t instanceof SortableCollection) {
      ((SortableCollection)t).sort(new DefaultComparator());
      System.out.println("...");
    }

    System.out.println("");
    while (!t.isEmpty()) {
      System.out.print(t.take() + " ");
    }
    System.out.println("");

  }



  static void t9(UpdatableMap s) {

    String vals[] = new String[size];
    for (int i = 0; i < size; ++i) vals[i] = nums[i].toString();
    

    Enumeration e = new ArrayEnumeration(nums);

    for (int i = 0; i < size; ++i) s.putAt(nums[i], vals[i]);
    System.out.println("...");

    for (int i = 0; i < size; ++i) s.putAt(nums[i], vals[i]);
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    for (int i = 0; i < size/2; ++i) s.removeAt(e.nextElement());
    System.out.println("...");

    for (int i = size/2; i < size; ++i) s.exclude(vals[i]);
    System.out.println("...");

    for (int i = 0; i < size; ++i) s.putAt(nums[i], vals[i]);
    System.out.println("...");

    for (int i = size/2; i < size; ++i) s.removeOneOf(vals[i]);
    System.out.println("...");

    for (int i = 0; i < size; ++i) s.putAt(nums[i], vals[i]);
    System.out.println("...");
    for (int i = size/3; i < size * 2 / 3; ++i) 
      s.replaceElement(nums[i], vals[i], vals[i+1]);
    System.out.println("...");

    s.replaceOneOf(nums[size-1], new Integer(999));
    System.out.println("...");

    System.out.println(s);
    System.out.println("...");

    System.out.println("");
    while (!s.isEmpty()) {
      System.out.print(s.take() + " ");
    }
    System.out.println("");

  }

  static void t10(Set s) {
    
    Set t1 = null;
    Set t2 = null;

    s.checkImplementation();
    Enumeration e = new ArrayEnumeration(nums);

    for (int i = 0; i < size; ++i) {
      if (i == size/2) t1 = s;
      Object v = nums[i];
      
      try {
        s = (Set)(s.including(v));
        s.checkImplementation();
      }
      catch (IllegalElementException ex) {
        if (s.canInclude(v)) System.out.println("?? can't include" + v);
      }
    }
    System.out.println("...");

    Enumeration ts = t1.elements();
    while (ts.hasMoreElements()) {
      Object v = ts.nextElement();
      if (!s.includes(v))
        System.out.println("?? no:" + v);
    }

    int k = 0;
    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) {
      if (k++ == size/4) t2 = s;
      Object v = e.nextElement();
      if (s.canInclude(v))
        s = (Set)(s.including(v));
    s.checkImplementation();
    }
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    for (int i = 0; i < size/2; ++i) 
      t2 = (Set)(t2.excluding(e.nextElement()));
    System.out.println("...");

    ts = t2.elements();
    while (ts.hasMoreElements()) {
      Object v = ts.nextElement();
      if (!s.includes(v))
        System.out.println("?? no:" + v);
    s.checkImplementation();
    }

    s = (Set)(s.replacingAllOf(nums[size-1], new Integer(999)));
    System.out.println("...");
    s.checkImplementation();

    System.out.println(s);
    System.out.println("...");
    s.checkImplementation();
    t1.checkImplementation();
    t2.checkImplementation();

    System.out.println(t1);
    System.out.println("...");

  }

  static void t11(Bag s) {
    
    Bag t1 = null;
    Bag t2 = null;
    Bag t3 = null;
    Bag t4 = null;

    s.checkImplementation();
    Enumeration e = new ArrayEnumeration(nums);

    for (int i = 0; i < size; ++i) {
      if (i == size/2) t1 = s;
      Object v = nums[i];
      
      try {
        s = (Bag)(s.addingIfAbsent(v));
        s.checkImplementation();
      }
      catch (IllegalElementException ex) {
        if (s.canInclude(v)) System.out.println("?? can't include" + v);
      }
    }
    System.out.println("...");

    Enumeration ts = t1.elements();
    while (ts.hasMoreElements()) {
      Object v = ts.nextElement();
      if (!s.includes(v))
        System.out.println("?? no:" + v);
    }

    int k = 0;
    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) {
      if (k++ == size/4) t2 = s;
      Object v = e.nextElement();
      if (s.canInclude(v))
        s = (Bag)(s.addingIfAbsent(v));
    s.checkImplementation();
    }
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    for (int i = 0; i < size/2; ++i) 
      t2 = (Bag)(t2.excluding(e.nextElement()));
    System.out.println("...");

    ts = t2.elements();
    while (ts.hasMoreElements()) {
      Object v = ts.nextElement();
      if (!s.includes(v))
        System.out.println("?? no:" + v);
    s.checkImplementation();
    }

    s = (Bag)(s.replacingAllOf(nums[size-1], new Integer(999)));
    System.out.println("...");
    s.checkImplementation();

    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) 
      s = (Bag)(s.adding(e.nextElement()));
    System.out.println("...");

    t3 = s;

    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) 
      s = (Bag)(s.adding(e.nextElement()));
    System.out.println("...");

    t4 = s;

    e = new ArrayEnumeration(nums);
    for (int i = size/2 + 1; i < size; ++i) 
      s = (Bag)(s.removingOneOf(e.nextElement()));
    System.out.println("...");

    Enumeration ss = s.elements();
    while (ss.hasMoreElements()) {
      Object v = ss.nextElement();
      if (!t4.includes(v))
        System.out.println("?? no:" + v);
    }

      
    e = new ArrayEnumeration(nums);
    for (int i = size/2 + 1; i < size; ++i) 
      t3 = (Bag)(t3.excluding(e.nextElement()));
    System.out.println("...");


    System.out.println(s);
    System.out.println("...");
    s.checkImplementation();
    t1.checkImplementation();
    t2.checkImplementation();
    t3.checkImplementation();
    t4.checkImplementation();
    
    System.out.println(t1);
    System.out.println("...");

    System.out.println(t2);
    System.out.println("...");

    System.out.println(t3);
    System.out.println("...");

    System.out.println(t4);
    System.out.println("...");

    Enumeration adds = new MappingEnumeration(t4.elements(), new AddOne());
    System.out.print("adds:");
    while (adds.hasMoreElements()) System.out.print(" " + adds.nextElement());
    System.out.println("...");

    Enumeration t1t2 = new InterleavingEnumeration(t1.elements(), 
                                                   t2.elements());

    System.out.print("t1t2:");
    while (t1t2.hasMoreElements()) 
      System.out.print(" " + t1t2.nextElement());
    System.out.println("...");
    

    Enumeration odds = new FilteringEnumeration(t3.elements(), new IsOdd());
    System.out.print("odds:");
    while (odds.hasMoreElements()) 
      System.out.print(" " + odds.nextElement());
    System.out.println("...");

  }


  static void t12(Seq s) {
    
    Seq t1 = null;
    Seq t2 = null;
    Seq t3 = null;
    Seq t4 = null;

    s.checkImplementation();
    Enumeration e = new ArrayEnumeration(nums);

    for (int i = 0; i < size; ++i) {
      if (i == size/2) t1 = s;
      Object v = nums[i];
      
      try {
        s = (Seq)(s.insertingAt(0,v));
        s.checkImplementation();
      }
      catch (IllegalElementException ex) {
        if (s.canInclude(v)) System.out.println("?? can't include" + v);
      }
    }
    System.out.println("...");

    Enumeration ts = t1.elements();
    while (ts.hasMoreElements()) {
      Object v = ts.nextElement();
      if (!s.includes(v))
        System.out.println("?? no:" + v);
    }
    System.out.println("...");

    int k = 0;
    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) {
      if (k == size/4) t2 = s;
      Object v = e.nextElement();
      if (s.canInclude(v))
        s = (Seq)(s.insertingAt(k, v));
    s.checkImplementation();
      ++k;
    }
    System.out.println("...");

    e = new ArrayEnumeration(nums);
    for (int i = 0; i < size/2; ++i) 
      t2 = (Seq)(t2.excluding(e.nextElement()));
    System.out.println("...");

    ts = t2.elements();
    while (ts.hasMoreElements()) {
      Object v = ts.nextElement();
      if (!s.includes(v))
        System.out.println("?? no:" + v);
    s.checkImplementation();
    }

    s = (Seq)(s.replacingAllOf(nums[size-1], new Integer(999)));
    System.out.println("...");
    s.checkImplementation();

    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) 
      s = (Seq)(s.insertingAt(s.size(), e.nextElement()));
    System.out.println("...");

    t3 = s;

    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) 
      s = (Seq)(s.insertingAt(0, e.nextElement()));
    System.out.println("...");

    k = 0;
    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) 
      t3 = (Seq)(t3.replacingAt(k++, e.nextElement()));
    System.out.println("...");

    t4 = s;

    e = new ArrayEnumeration(nums);
    for (int i = size/2 + 1; i < size; ++i) 
      s = (Seq)(s.removingOneOf(e.nextElement()));
    System.out.println("...");


    e = new ArrayEnumeration(nums);
    for (int i = size/2 + 1; i < size; ++i) 
      s = (Seq)(s.removingAt(i));
    System.out.println("...");

    Enumeration ss = s.elements();
    while (ss.hasMoreElements()) {
      Object v = ss.nextElement();
      if (!t4.includes(v))
        System.out.println("?? no:" + v);
    }

      
    e = new ArrayEnumeration(nums);
    for (int i = size/2 + 1; i < size; ++i) 
      t3 = (Seq)(t3.excluding(e.nextElement()));
    System.out.println("...");


    System.out.println(s);
    System.out.println("...");
    s.checkImplementation();
    t1.checkImplementation();
    t2.checkImplementation();
    t3.checkImplementation();
    t4.checkImplementation();
    
    System.out.println(t1);
    System.out.println("...");

    System.out.println(t2);
    System.out.println("...");

    System.out.println(t3);
    System.out.println("...");

    t4 = (Seq)(s.subseq(0, s.size()/2));
    System.out.println(t4);
    System.out.println("...");

  }


  static void t13(Map s) {
    

    Map t1 = null;
    Map t2 = null;
    Map t3 = null;
    Map t4 = null;

    String vals[] = new String[size];
    for (int i = 0; i < size; ++i) vals[i] = nums[i].toString();

    s.checkImplementation();
    Enumeration e = new ArrayEnumeration(nums);

    for (int i = 0; i < size; ++i) {
      if (i == size/2) t1 = s;
      Object v = nums[i];
      
      try {
        s = (Map)(s.puttingAt(v, vals[i]));
        s.checkImplementation();
      }
      catch (IllegalElementException ex) {
        if (s.canInclude(v)) System.out.println("?? can't include" + v);
      }
    }
    System.out.println("...");

    Enumeration ts = t1.elements();
    while (ts.hasMoreElements()) {
      Object v = ts.nextElement();
      if (!s.includes(v))
        System.out.println("?? no:" + v);
    }

    int k = 0;
    e = new ArrayEnumeration(nums);
    while (e.hasMoreElements()) {
      if (k == size/4) t2 = s;
      Object v = e.nextElement();
      if (s.canInclude(v))
        s = (Map)(s.puttingAt(v, vals[k]));
    s.checkImplementation();
      ++k;
    }
    System.out.println("...");

    e = new ArrayEnumeration(vals);
    for (int i = 0; i < size/2; ++i) 
      t2 = (Map)(t2.excluding(e.nextElement()));
    System.out.println("...");

    ts = t2.elements();
    while (ts.hasMoreElements()) {
      Object v = ts.nextElement();
      if (!s.includes(v))
        System.out.println("?? no:" + v);
    s.checkImplementation();
    }

    s = (Map)(s.replacingAllOf(vals[size-1], "XXX"));
    System.out.println("...");
    s.checkImplementation();

    for (int i = 0; i < size; ++i) 
      s = (Map)(s.puttingAt(nums[i], vals[i]));
    System.out.println("...");

    t3 = s;

    for (int i = 0; i < size; ++i) {
      s = (Map)(s.puttingAt(nums[i], vals[i]));
      s.checkImplementation();
    }
    System.out.println("...");

    t4 = s;

    e = new ArrayEnumeration(vals);
    for (int i = size/2 + 1; i < size; ++i) {
      s = (Map)(s.removingOneOf(e.nextElement()));
      s.checkImplementation();
    }
    System.out.println("...");


    e = new ArrayEnumeration(nums);
    for (int i = size/2 + 1; i < size; ++i) {
      s = (Map)(s.removingAt(nums[i]));
      s.checkImplementation();
    }
    System.out.println("...");

    s.checkImplementation();
    t4.checkImplementation();
    Enumeration ss = s.elements();
    while (ss.hasMoreElements()) {
      Object v = ss.nextElement();
      if (!t4.includes(v))
        System.out.println("?? no:" + v);
    }

      
    e = new ArrayEnumeration(vals);
    for (int i = size/2 + 1; i < size; ++i) 
      t3 = (Map)(t3.excluding(e.nextElement()));
    System.out.println("...");


    System.out.println(s);
    System.out.println("...");
    s.checkImplementation();
    t1.checkImplementation();
    t2.checkImplementation();
    t3.checkImplementation();
    t4.checkImplementation();
    
    System.out.println(t1);
    System.out.println("...");

    System.out.println(t2);
    System.out.println("...");

    System.out.println(t3);
    System.out.println("...");

    System.out.println(t4);
    System.out.println("...");

  }


  static public void main(String args[]) {

    nums = new Integer[size];
    for (int i = 0; i < size; ++i) nums[i] = new Integer(i);
    randomPermute(nums);

    Comparator c = new DefaultComparator();
    Predicate odd = new IsOdd();
    t2(new HashedSet());
    t2(new HashedSet(odd));
    t4(new LinkedBuffer());
    t4(new RBTree(c));
    t6(new LinkedList());
    t6(new Dynarray());
    t6(new CircularList());
    t9(new HashedMap());
    t9(new LLMap());
    t9(new RBMap(c));

    t2(new CheckedSet(new HashedSet()));
    t2(new CheckedSet(new HashedSet(odd)));
    t4(new CheckedBag(new LinkedBuffer()));
    t4(new CheckedBag(new RBTree(c)));
    t6(new CheckedSeq(new LinkedList()));
    t6(new CheckedSeq(new Dynarray()));
    t6(new CheckedSeq(new CircularList()));
    t9(new CheckedMap(new HashedMap()));
    t9(new CheckedMap(new LLMap()));
    t9(new CheckedMap(new RBMap(c)));

    t10(new CheckedSet(new HashedSet()));
    t11(new CheckedBag(new LinkedBuffer()));
    t11(new CheckedBag(new RBTree(c)));
    t12(new CheckedSeq(new LinkedList()));
    t12(new CheckedSeq(new Dynarray()));
    t12(new CheckedSeq(new CircularList()));
    t13(new CheckedMap(new HashedMap()));
    t13(new CheckedMap(new LLMap()));
    t13(new CheckedMap(new RBMap(c)));

    t10(new IncrSet(new CheckedSet(new HashedSet())));
    t11(new IncrBag(new CheckedBag(new LinkedBuffer())));
    t11(new IncrBag(new CheckedBag(new RBTree(c))));
    t12(new IncrSeq(new CheckedSeq(new LinkedList())));
    t12(new IncrSeq(new CheckedSeq(new Dynarray())));
    t12(new IncrSeq(new CheckedSeq(new CircularList())));
    t13(new IncrMap(new CheckedMap(new HashedMap())));
    t13(new IncrMap(new CheckedMap(new LLMap())));
    t13(new IncrMap(new CheckedMap(new RBMap(c))));

  }

}


class IsOdd implements Predicate {

  public boolean predicate(Object v) {
    if (!(v instanceof Number)) return false;
    Number n = (Number)(v);
    int i = n.intValue();
    return (i % 2) == 1;
  }

}

class AddOne implements Function {

  public Object function(Object v) {
    if (v instanceof Number) 
      return new Integer(((Number)v).intValue()+1);
    else 
      return new Integer(-888);
  }
}
