/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PlaceFigure;
import de.renew.gui.ShadowHolder;
import de.renew.gui.TransitionFigure;
import de.renew.io.WoflanFileFilter;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.ShadowTransition;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class WoflanExportFormat
extends ExportFormatAbstract {
    public WoflanExportFormat() {
        super("Woflan", (FileFilter)((Object)new WoflanFileFilter()));
    }

    public boolean canExportNto1() {
        return false;
    }

    public File export(Drawing drawing, File file) throws Exception {
        File file2 = null;
        if (drawing != null && file != null) {
            Object object;
            ShadowPlace shadowPlace;
            Figure figure;
            file2 = file;
            ModeReplacement.getInstance().getSimulation().buildAllShadows();
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2));
            int n = 0;
            FigureEnumeration figureEnumeration = drawing.figures();
            while (figureEnumeration.hasMoreElements()) {
                figure = figureEnumeration.nextFigure();
                if (!(figure instanceof PlaceFigure)) continue;
                shadowPlace = (ShadowPlace)((ShadowHolder)figure).getShadow();
                object = shadowPlace.getName();
                if (object == null) {
                    object = "P" + ++n;
                    shadowPlace.setName((String)object);
                }
                printWriter.println("place " + (String)object + ";");
            }
            n = 0;
            figure = drawing.figures();
            while (figure.hasMoreElements()) {
                Object object22;
                shadowPlace = figure.nextFigure();
                if (!(shadowPlace instanceof TransitionFigure)) continue;
                object = (ShadowTransition)((ShadowHolder)shadowPlace).getShadow();
                Object object3 = object.getName();
                if (object3 == null) {
                    object3 = "T" + ++n;
                    object.setName((String)object3);
                }
                Vector<String> vector = new Vector<String>();
                Vector<String> vector2 = new Vector<String>();
                for (Object object22 : object.elements()) {
                    if (!(object22 instanceof ShadowInscription) || !((ShadowInscription)object22).inscr.startsWith(":new(")) continue;
                    vector.addElement("pinit");
                }
                object22 = drawing.figures();
                while (object22.hasMoreElements()) {
                    shadowPlace = object22.nextFigure();
                    if (!(shadowPlace instanceof ArcConnection)) continue;
                    ArcConnection arcConnection = (ArcConnection)shadowPlace;
                    ShadowArc shadowArc = (ShadowArc)arcConnection.getShadow();
                    if (shadowArc.transition != object) continue;
                    String string = shadowArc.place.getName();
                    if (shadowArc.shadowArcType == 2 || shadowArc.shadowArcType == 0) {
                        vector.addElement(string);
                        vector2.addElement(string);
                        continue;
                    }
                    if (shadowArc.shadowArcType != 1) continue;
                    if (shadowArc.placeToTransition) {
                        vector.addElement(string);
                        continue;
                    }
                    vector2.addElement(string);
                }
                printWriter.println("trans " + (String)object3 + this.placeVector(vector, " in") + this.placeVector(vector2, " out") + ";");
            }
            printWriter.close();
        }
        assert (file2 != null) : "Failure in WoflanExportFormat: result == null";
        return file2;
    }

    public File export(Drawing[] drawingArray, File file) throws Exception {
        File file2 = null;
        assert (file2 != null) : "Failure in WoflanExportFormat: result == null";
        return file2;
    }

    private String placeVector(Vector<String> vector, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (vector.size() > 0) {
            stringBuffer.append(string);
            for (int i = vector.size() - 1; i >= 0; --i) {
                stringBuffer.append(" ").append(vector.elementAt(i));
            }
        }
        return stringBuffer.toString();
    }

    public boolean canExportDrawing(Drawing drawing) {
        boolean bl = false;
        if (drawing instanceof CPNDrawing) {
            bl = true;
        }
        return bl;
    }
}

