/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import CH.ifa.draw.util.Iconkit;
import de.renew.navigator.gui.FileTreeNode;
import de.renew.navigator.models.TreeElement;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public abstract class FileTreeCellRenderer
implements TreeCellRenderer {
    private final LinkedList<FileTreeCellRenderer> additionalRenderers = new LinkedList();
    private final DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer();

    public abstract void render(DefaultTreeCellRenderer var1, TreeElement var2, boolean var3, boolean var4);

    @Override
    public final Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.cellRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.cellRenderer.setFont(jTree.getFont());
        if (!(object instanceof FileTreeNode)) {
            return this.cellRenderer;
        }
        TreeElement treeElement = ((FileTreeNode)object).getModel();
        this.render(this.cellRenderer, treeElement, bl, bl2);
        for (FileTreeCellRenderer fileTreeCellRenderer : this.additionalRenderers) {
            fileTreeCellRenderer.render(this.cellRenderer, treeElement, bl, bl2);
        }
        return this.cellRenderer;
    }

    public void addAdditionalRenderer(FileTreeCellRenderer fileTreeCellRenderer) {
        this.additionalRenderers.add(fileTreeCellRenderer);
    }

    public boolean removeAdditionalRenderer(FileTreeCellRenderer fileTreeCellRenderer) {
        return this.additionalRenderers.remove(fileTreeCellRenderer);
    }

    protected static Icon loadIcon(String string) {
        return new ImageIcon(Iconkit.instance().loadImage(string).getScaledInstance(16, 16, 4));
    }

    protected static void applyIcon(JLabel jLabel, String string) {
        jLabel.setIcon(FileTreeCellRenderer.loadIcon(string));
    }
}

