/*
 * Decompiled with CFR 0.152.
 */
package de.renew.call;

import de.renew.call.SynchronisationOccurrence;
import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.ChannelBinder;
import de.renew.engine.searcher.ChannelTarget;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.TriggerCollectionImpl;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.unify.Variable;
import de.renew.util.Lock;
import de.renew.util.Orderer;
import de.renew.util.Semaphor;

public class SynchronisationRequest
implements Searchable,
Triggerable {
    private ChannelTarget channelTarget;
    private String channelName;
    Tuple parameters;
    Tuple resultParameters;
    Semaphor resultSemaphor;
    boolean completed;
    final long lockOrder;
    final Lock lock;
    private TriggerCollection triggers = new TriggerCollectionImpl((Triggerable)this);

    public SynchronisationRequest(ChannelTarget channelTarget, String string, Tuple tuple) {
        this.channelTarget = channelTarget;
        this.channelName = string;
        this.parameters = tuple;
        this.resultParameters = null;
        this.resultSemaphor = new Semaphor();
        this.completed = false;
        this.lockOrder = Orderer.getTicket();
        this.lock = new Lock();
    }

    public static Tuple synchronize(ChannelTarget channelTarget, String string, Tuple tuple) {
        SynchronisationRequest synchronisationRequest = new SynchronisationRequest(channelTarget, string, tuple);
        synchronisationRequest.proposeSearch();
        return synchronisationRequest.getResult();
    }

    public TriggerCollection triggers() {
        return this.triggers;
    }

    public void proposeSearch() {
        SearchQueue.includeNow((Searchable)this);
    }

    public Tuple getResult() {
        this.resultSemaphor.P();
        return this.resultParameters;
    }

    public synchronized void startSearch(final Searcher searcher) {
        final SynchronisationRequest synchronisationRequest = this;
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                if (SynchronisationRequest.this.completed) {
                    return;
                }
                Variable variable = new Variable((Object)SynchronisationRequest.this.parameters, searcher.recorder);
                try {
                    searcher.calcChecker.addLateVariable(variable, searcher.recorder);
                }
                catch (Impossible impossible) {
                    throw new RuntimeException("Calculation checker refused to make fresh variable late.");
                }
                Variable variable2 = new Variable((Object)SynchronisationRequest.this.channelTarget, searcher.recorder);
                ChannelBinder channelBinder = new ChannelBinder(variable2, SynchronisationRequest.this.channelName, variable, false);
                searcher.addBinder((Binder)channelBinder);
                SynchronisationOccurrence synchronisationOccurrence = new SynchronisationOccurrence(synchronisationRequest);
                searcher.addOccurrence((Occurrence)synchronisationOccurrence);
                searcher.search();
                searcher.removeOccurrence((Occurrence)synchronisationOccurrence);
                searcher.removeBinder((Binder)channelBinder);
                searcher.recorder.restore();
            }
        });
    }
}

