/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.net.arc.FlexibleArc;
import de.renew.net.arc.InputArcExecutable;
import de.renew.unify.Impossible;
import java.util.Vector;

class FlexibleInArcExecutable
implements EarlyExecutable {
    SimulatablePlaceInstance pInstance;
    TransitionInstance tInstance;
    Vector<Object> tokens;
    FlexibleArc arc;
    int numRemoved;
    Vector<Double> removedTimes;

    FlexibleInArcExecutable(SimulatablePlaceInstance simulatablePlaceInstance, TransitionInstance transitionInstance, Vector<Object> vector, FlexibleArc flexibleArc) {
        this.pInstance = simulatablePlaceInstance;
        this.tInstance = transitionInstance;
        this.tokens = vector;
        this.arc = flexibleArc;
        this.numRemoved = 0;
        this.removedTimes = new Vector();
    }

    public long lockPriority() {
        return this.pInstance.lockOrder;
    }

    @Override
    public int phase() {
        return -3;
    }

    public void lock() {
        this.pInstance.lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        try {
            for (int i = 0; i < this.tokens.size(); ++i) {
                Object object = this.tokens.elementAt(i);
                double d = this.pInstance.removeToken(object, 0.0);
                this.removedTimes.addElement(new Double(d));
                ++this.numRemoved;
            }
        }
        catch (Exception exception) {
            this.rollback();
            throw new Impossible();
        }
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        for (int i = 0; i < this.numRemoved; ++i) {
            Object object = this.tokens.elementAt(i);
            if (this.arc.arcType == 3) {
                if (this.arc.trace) {
                    InputArcExecutable.traceInArc(stepIdentifier, true, object, this.pInstance, this.tInstance);
                }
                this.pInstance.insertToken(object, SearchQueue.getTime());
                continue;
            }
            if (!this.arc.trace) continue;
            InputArcExecutable.traceInArc(stepIdentifier, false, object, this.pInstance, this.tInstance);
        }
    }

    @Override
    public void rollback() {
        for (int i = 0; i < this.numRemoved; ++i) {
            this.pInstance.internallyInsertToken(this.tokens.elementAt(i), this.removedTimes.elementAt(i), false);
        }
    }

    public void unlock() {
        this.pInstance.lock.unlock();
    }
}

