/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.IDCounter;
import de.renew.net.IDSource;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class IDRegistry
implements Serializable {
    private static IDRegistry _instance = null;
    private transient Map<Object, Object> table = new HashMap<Object, Object>();

    public static synchronized IDRegistry getInstance() {
        if (_instance == null) {
            _instance = new IDRegistry();
        }
        return _instance;
    }

    private IDCounter register(Object object) {
        IDCounter iDCounter = (IDCounter)this.table.get(object);
        if (iDCounter == null) {
            iDCounter = new IDCounter(IDSource.createID());
            this.table.put(object, iDCounter);
        }
        return iDCounter;
    }

    public synchronized String getID(Object object) {
        return this.register(object).getID();
    }

    public synchronized void reserve(Object object, int n) {
        this.register(object).reserve(n);
    }

    public synchronized void reserve(Object object) {
        this.register(object).reserve();
    }

    public synchronized void unreserve(Object object) {
        IDCounter iDCounter = this.register(object);
        iDCounter.unreserve();
        if (iDCounter.isDiscardable()) {
            this.table.remove(object);
        }
    }

    public synchronized void setAndReserveID(Object object, String string) {
        IDCounter iDCounter = (IDCounter)this.table.get(object);
        if (iDCounter == null) {
            iDCounter = new IDCounter(string);
            this.table.put(object, iDCounter);
        } else if (!iDCounter.getID().equals(string)) {
            throw new RuntimeException("Token already in use.");
        }
        iDCounter.reserve();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        objectInputStream.defaultReadObject();
        this.table = new HashMap<Object, Object>();
        boolean bl = false;
        do {
            Object object;
            if ((object = objectInputStream.readObject()) == null) {
                bl = true;
                continue;
            }
            Object object2 = objectInputStream.readObject();
            this.table.put(object, object2);
        } while (!bl);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain((Object)this);
        }
        objectOutputStream.defaultWriteObject();
        for (Map.Entry<Object, Object> entry : this.table.entrySet()) {
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            objectOutputStream.writeObject(object);
            objectOutputStream.writeObject(object2);
        }
        objectOutputStream.writeObject(null);
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain((Object)this);
        }
    }

    public static synchronized void reset() {
        _instance = null;
    }

    public static synchronized void save(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(_instance);
    }

    public static synchronized void load(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        _instance = (IDRegistry)objectInput.readObject();
    }
}

