/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.ExpressionWithTypeField;
import de.renew.expression.Function;
import de.renew.expression.VariableMapper;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Types;

public class InvertibleExpression
extends ExpressionWithTypeField {
    Expression argument;
    Function forwardFunction;
    Function backwardFunction;

    public InvertibleExpression(Class<?> clazz, Expression expression, Function function, Function function2) {
        super(clazz);
        this.argument = expression;
        this.forwardFunction = function;
        this.backwardFunction = function2;
    }

    @Override
    public boolean isInvertible() {
        return this.argument.isInvertible();
    }

    public Expression getArgument() {
        return this.argument;
    }

    @Override
    public Object startEvaluation(VariableMapper variableMapper, StateRecorder stateRecorder, CalculationChecker calculationChecker) throws Impossible {
        final Variable variable = new Variable(this.argument.startEvaluation(variableMapper, stateRecorder, calculationChecker), stateRecorder);
        final Variable variable2 = new Variable();
        if (calculationChecker != null) {
            calculationChecker.addEarlyVariable(variable, stateRecorder);
        }
        Notifiable notifiable = new Notifiable(){

            @Override
            public void boundNotify(StateRecorder stateRecorder) throws Impossible {
                if (Unify.isBound(variable)) {
                    Unify.unify(variable2, InvertibleExpression.this.forwardFunction.function(variable.getValue()), stateRecorder);
                }
            }
        };
        variable.addListener(notifiable, stateRecorder);
        Notifiable notifiable2 = new Notifiable(){

            @Override
            public void boundNotify(StateRecorder stateRecorder) throws Impossible {
                if (Unify.isBound(variable2)) {
                    Unify.unify(variable, InvertibleExpression.this.backwardFunction.function(variable2.getValue()), stateRecorder);
                }
            }
        };
        variable2.addListener(notifiable2, stateRecorder);
        return variable2.getValue();
    }

    @Override
    public Object registerCalculation(VariableMapper variableMapper, StateRecorder stateRecorder, CalculationChecker calculationChecker) throws Impossible {
        Variable variable = new Variable(this.argument.registerCalculation(variableMapper, stateRecorder, calculationChecker), stateRecorder);
        Variable variable2 = new Variable();
        calculationChecker.addLateVariable(variable, stateRecorder);
        calculationChecker.addCalculated(this.getType(), variable2, variable.getValue(), stateRecorder);
        return variable2.getValue();
    }

    public String toString() {
        return "InvertibleExpr(" + Types.typeToString((Class)this.getType()) + ": " + String.valueOf(this.forwardFunction) + ", " + String.valueOf(this.backwardFunction) + ", " + String.valueOf(this.argument) + ")";
    }
}

