/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searcher;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.BindingBadness;
import de.renew.engine.searcher.ChannelTarget;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.UplinkProvider;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.unify.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ChannelBinder
implements Binder {
    private Variable targetVariable;
    private String name;
    private Variable params;
    private boolean isOptional;

    public ChannelBinder(Variable variable, String string, Variable variable2, boolean bl) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.targetVariable = variable;
        this.name = string;
        this.params = variable2;
        this.isOptional = bl;
    }

    @Override
    public int bindingBadness(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Object object = this.targetVariable.getValue();
        if (object instanceof ChannelTarget) {
            ChannelTarget channelTarget = (ChannelTarget)object;
            Collection<UplinkProvider> collection = channelTarget.getUplinkProviders(this.name);
            return BindingBadness.clip(collection.size());
        }
        return 10000;
    }

    @Override
    public void bind(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ChannelTarget channelTarget = (ChannelTarget)this.targetVariable.getValue();
        ArrayList<UplinkProvider> arrayList = new ArrayList<UplinkProvider>(channelTarget.getUplinkProviders(this.name));
        Collections.shuffle(arrayList);
        Iterator iterator = arrayList.iterator();
        if (this.isOptional && !iterator.hasNext()) {
            searcher.search();
        } else {
            while (iterator.hasNext() && !searcher.isCompleted()) {
                UplinkProvider uplinkProvider = (UplinkProvider)iterator.next();
                uplinkProvider.bindChannel(this.params, searcher);
            }
        }
    }
}

