/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.NetAction;
import de.renew.database.TokenAction;
import de.renew.database.Transaction;
import de.renew.database.TransactionStrategy;
import java.util.Hashtable;

public class TransactionSource {
    private static TransactionStrategy strategy = null;
    private static Hashtable<Thread, Transaction> transactions = new Hashtable();
    private static Object hashtableLock = new Object();
    private static Object strategyLock = new Object();

    private TransactionSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStrategy(TransactionStrategy transactionStrategy) {
        Object object = strategyLock;
        synchronized (object) {
            strategy = transactionStrategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void perform(NetAction[] netActionArray, TokenAction[] tokenActionArray, TokenAction[] tokenActionArray2, NetAction[] netActionArray2) throws Exception {
        Object object = strategyLock;
        synchronized (object) {
            if (strategy != null) {
                strategy.perform(netActionArray, tokenActionArray, tokenActionArray2, netActionArray2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void netInstanceDrawingOpened(String string) throws Exception {
        Object object = strategyLock;
        synchronized (object) {
            if (strategy != null) {
                strategy.netInstanceDrawingOpened(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void netInstanceDrawingClosed(String string) throws Exception {
        Object object = strategyLock;
        synchronized (object) {
            if (strategy != null) {
                strategy.netInstanceDrawingClosed(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void simulationStateChanged(boolean bl, boolean bl2) throws Exception {
        Object object = strategyLock;
        synchronized (object) {
            if (strategy != null) {
                strategy.simulationStateChanged(bl, bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        Object object = hashtableLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            if (transactions.containsKey(thread)) {
                throw new RuntimeException("Nested transactions not supported.");
            }
            transactions.put(Thread.currentThread(), new Transaction(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transaction get() {
        Object object = hashtableLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            Transaction transaction = transactions.get(thread);
            if (transaction != null) {
                return transaction;
            }
            return new Transaction(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Transaction extractCurrentTransaction() {
        Object object = hashtableLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            Transaction transaction = transactions.get(thread);
            if (transaction != null) {
                transactions.remove(thread);
            }
            return transaction;
        }
    }

    public static void commit() throws Exception {
        Transaction transaction = TransactionSource.extractCurrentTransaction();
        if (transaction != null) {
            transaction.commit();
        }
    }

    public static void rollback() {
        Transaction transaction = TransactionSource.extractCurrentTransaction();
        if (transaction != null) {
            transaction.rollback();
        }
    }
}

