/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.util.Hashtable;

public class Base64Coder {
    private static final char[] ENCODE_ARRAY = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final Hashtable<Character, Integer> DECODE_TABLE = new Hashtable();

    public static String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(byArray.length));
        stringBuffer.append(":");
        for (int i = 0; i < byArray.length; i += 3) {
            int n = i + 0 < byArray.length ? byArray[i + 0] : 0;
            n = n < 0 ? n + 256 : n;
            int n2 = i + 1 < byArray.length ? byArray[i + 1] : 0;
            n2 = n2 < 0 ? n2 + 256 : n2;
            int n3 = i + 2 < byArray.length ? byArray[i + 2] : 0;
            n3 = n3 < 0 ? n3 + 256 : n3;
            int n4 = n + n2 * 256 + n3 * 256 * 256;
            stringBuffer.append(ENCODE_ARRAY[n4 % 64]);
            stringBuffer.append(ENCODE_ARRAY[(n4 /= 64) % 64]);
            stringBuffer.append(ENCODE_ARRAY[(n4 /= 64) % 64]);
            stringBuffer.append(ENCODE_ARRAY[(n4 /= 64) % 64]);
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String string) {
        int n;
        int n2 = string.indexOf(":");
        if (n2 < 0) {
            throw new IllegalArgumentException("Not a valid base 64 string (no colon)");
        }
        try {
            n = Integer.parseInt(string.substring(0, n2));
            string = string.substring(n2 + 1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Not a valid base 64 string (invalid length number)");
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n3 * 4 < string.length()) {
            try {
                char c = string.charAt(n3 * 4 + 0);
                char c2 = string.charAt(n3 * 4 + 1);
                char c3 = string.charAt(n3 * 4 + 2);
                char c4 = string.charAt(n3 * 4 + 3);
                int n4 = DECODE_TABLE.get(new Character(c)) + DECODE_TABLE.get(new Character(c2)) * 64 + DECODE_TABLE.get(new Character(c3)) * 64 * 64 + DECODE_TABLE.get(new Character(c4)) * 64 * 64 * 64;
                if (n3 * 3 + 0 < n) {
                    byArray[n3 * 3 + 0] = (byte)(n4 % 256);
                }
                n4 /= 256;
                if (n3 * 3 + 1 < n) {
                    byArray[n3 * 3 + 1] = (byte)(n4 % 256);
                }
                n4 /= 256;
                if (n3 * 3 + 2 < n) {
                    byArray[n3 * 3 + 2] = (byte)(n4 % 256);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("Not a valid base 64 string (illegal character)");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException("Not a valid base 64 string (mismatching length)");
            }
            ++n3;
        }
        return byArray;
    }

    static {
        for (int i = 0; i < 64; ++i) {
            DECODE_TABLE.put(new Character(ENCODE_ARRAY[i]), new Integer(i));
        }
    }
}

