/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.expression.LocalVariable;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedImportDecl;
import de.renew.formalism.java.Token;
import de.renew.util.ClassSource;
import de.renew.util.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParsedDeclarationNode {
    private List<String> imports = new ArrayList<String>();
    private Map<String, String> wellKnownClassesNames;
    private Map<String, Class<?>> wellKnownClasses = new HashMap();
    private Map<String, Class<?>> variables;
    private boolean anyVariablesDeclared = false;
    private Map<String, List<Integer>> variablePositions;

    public ParsedDeclarationNode() {
        this.wellKnownClassesNames = new HashMap<String, String>();
        this.variables = new HashMap();
        this.variablePositions = new HashMap<String, List<Integer>>();
    }

    public void addImport(ParsedImportDecl parsedImportDecl, Token token) throws ParseException {
        if (parsedImportDecl.star) {
            this.imports.add(parsedImportDecl.name);
        } else {
            Class<?> clazz;
            int n = parsedImportDecl.name.lastIndexOf(".");
            String string = parsedImportDecl.name.substring(n + 1);
            try {
                clazz = this.interpreteWellKnownName(string);
                if (clazz != null) {
                    throw JavaHelper.makeParseException("Class " + string + " imported twice.", token);
                }
            }
            catch (LinkageError linkageError) {
                throw JavaHelper.makeParseException("Class " + string + " imported twice.\nAdditionally, first import cannot be loaded due to " + linkageError.toString(), token);
            }
            try {
                clazz = ParsedDeclarationNode.classForName(parsedImportDecl.name);
            }
            catch (RuntimeException runtimeException) {
                throw JavaHelper.makeParseException("Could not import class " + parsedImportDecl.name + ".", token);
            }
            this.wellKnownClasses.put(string, clazz);
            this.wellKnownClassesNames.put(string, parsedImportDecl.name);
        }
    }

    public void addVariable(Class<?> clazz, String string, Token token) throws ParseException {
        List<Integer> list;
        try {
            list = this.interpreteWellKnownName(string);
            if (list != null) {
                if (list instanceof LocalVariable) {
                    throw JavaHelper.makeParseException("Variable " + string + " declared twice.", token);
                }
                if (list instanceof Class) {
                    throw JavaHelper.makeParseException("Variable " + string + " is named identically to an imported class.", token);
                }
                throw JavaHelper.makeParseException("Variable " + string + " is named identically to a " + list.getClass().getName() + ".", token);
            }
        }
        catch (LinkageError linkageError) {
            throw JavaHelper.makeParseException("Variable " + string + " is named identically to an imported class.\nAdditionally, the class cannot be loaded due to" + linkageError.toString(), token);
        }
        this.variables.put(string, clazz);
        list = Arrays.asList(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
        this.variablePositions.put(string, list);
        if (!"this".equals(string)) {
            this.anyVariablesDeclared = true;
        }
    }

    private static boolean classExists(String string) throws LinkageError {
        try {
            ClassSource.classForName((String)string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static Class<?> classForName(String string) throws LinkageError {
        try {
            return ClassSource.classForName((String)string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Could not load class: " + string, classNotFoundException);
        }
    }

    public Object interpreteWellKnownName(String string) throws LinkageError {
        String string2;
        if (this.variables.containsKey(string)) {
            return new LocalVariable(string);
        }
        if (this.wellKnownClassesNames.containsKey(string) && ParsedDeclarationNode.classExists(string2 = this.wellKnownClassesNames.get(string))) {
            return ParsedDeclarationNode.classForName(string2);
        }
        return null;
    }

    public Object interpreteName(String string) throws LinkageError {
        if (string.indexOf(".") >= 0) {
            if (ParsedDeclarationNode.classExists(string)) {
                return ParsedDeclarationNode.classForName(string);
            }
            return null;
        }
        Object object = this.interpreteWellKnownName(string);
        if (object != null) {
            return object;
        }
        for (String string2 : this.imports) {
            if (!ParsedDeclarationNode.classExists(string2 + "." + string)) continue;
            return ParsedDeclarationNode.classForName(string2 + "." + string);
        }
        if (ParsedDeclarationNode.classExists(string)) {
            return ParsedDeclarationNode.classForName(string);
        }
        if (ParsedDeclarationNode.classExists("java.lang." + string)) {
            return ParsedDeclarationNode.classForName("java.lang." + string);
        }
        if (!this.anyVariablesDeclared) {
            return new LocalVariable(string);
        }
        return null;
    }

    public Class<?> findType(LocalVariable localVariable) {
        if (this.variables.containsKey(localVariable.name)) {
            return this.variables.get(localVariable.name);
        }
        return Types.UNTYPED;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("(");
        stringBuffer.append("imports=").append(this.imports);
        stringBuffer.append(", ");
        stringBuffer.append("wellKnownClasses=").append(this.wellKnownClassesNames);
        stringBuffer.append(", ");
        stringBuffer.append("variables=").append(this.variables);
        stringBuffer.append(", ");
        stringBuffer.append("anyVariablesDeclared=").append(this.anyVariablesDeclared);
        this.augmentToString(stringBuffer, ", ");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected void augmentToString(StringBuffer stringBuffer, String string) {
    }

    public Map<String, Class<?>> getWellKnownClasses() {
        return this.wellKnownClasses;
    }

    public Map<String, Class<?>> getVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    public Map<String, List<Integer>> getVariablePositions() {
        return Collections.unmodifiableMap(this.variablePositions);
    }
}

