/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.locate;

import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import de.renew.plugin.locate.PluginLocationFinder;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class PluginLocationFinders
implements PluginLocationFinder {
    private static PluginLocationFinders _instance;
    private Collection<PluginLocationFinder> _finders = new Vector<PluginLocationFinder>();

    private PluginLocationFinders() {
    }

    public static PluginLocationFinders getInstance() {
        if (_instance == null) {
            _instance = new PluginLocationFinders();
        }
        return _instance;
    }

    public void addLocationFinder(PluginLocationFinder pluginLocationFinder) {
        this._finders.add(pluginLocationFinder);
    }

    public void removeLocationFinder(PluginLocationFinder pluginLocationFinder) {
        this._finders.remove(pluginLocationFinder);
    }

    @Override
    public Collection<PluginProperties> findPluginLocations() {
        Iterator iterator;
        Vector<PluginProperties> vector = new Vector<PluginProperties>();
        for (PluginLocationFinder collection : this._finders) {
            iterator = collection.findPluginLocations();
            vector.addAll((Collection<PluginProperties>)((Object)iterator));
        }
        PluginProperties pluginProperties = PluginProperties.getUserProperties();
        if (pluginProperties.getBoolProperty("de.renew.plugin.autoLoad", true)) {
            Collection<String> collection = PropertyHelper.parseListString(pluginProperties.getProperty("de.renew.plugin.noLoad", ""));
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                PluginProperties pluginProperties2 = (PluginProperties)iterator.next();
                if (!collection.contains(pluginProperties2.getName())) continue;
                iterator.remove();
            }
        } else {
            Collection<String> collection = PropertyHelper.parseListString(pluginProperties.getProperty("de.renew.plugin.load", ""));
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                PluginProperties pluginProperties3 = (PluginProperties)iterator.next();
                if (collection.contains(pluginProperties3.getName())) continue;
                iterator.remove();
            }
        }
        return vector;
    }

    @Override
    public PluginProperties checkPluginLocation(URL uRL) {
        PluginProperties pluginProperties = null;
        for (PluginLocationFinder pluginLocationFinder : this._finders) {
            pluginProperties = pluginLocationFinder.checkPluginLocation(uRL);
        }
        return pluginProperties;
    }
}

