/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.load;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.di.DIPlugin;
import de.renew.plugin.di.DependencyFinder;
import de.renew.plugin.di.MissingDependencyException;
import de.renew.plugin.di.ServiceContainer;
import de.renew.plugin.load.PluginInstantiationException;
import de.renew.plugin.load.SimplePluginLoader;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class DIPluginLoader
extends SimplePluginLoader
implements DependencyFinder {
    public static Logger logger = Logger.getLogger(DIPluginLoader.class);

    public DIPluginLoader(PluginClassLoader pluginClassLoader, ServiceContainer serviceContainer) {
        super(pluginClassLoader, serviceContainer);
    }

    @Override
    public Object findDependency(Class<?> clazz) throws MissingDependencyException {
        return this.container.get(clazz);
    }

    @Override
    protected IPlugin createPlugin(PluginProperties pluginProperties, Class<? extends IPlugin> clazz) throws PluginInstantiationException {
        Class<?>[] classArray;
        Constructor<?> constructor = this.findInjectionPoint(clazz);
        if (constructor == null) {
            try {
                IPlugin iPlugin = clazz.newInstance();
                if (iPlugin instanceof DIPlugin) {
                    logger.warn((Object)(pluginProperties.getName() + " has no injection point."));
                    DIPlugin dIPlugin = (DIPlugin)iPlugin;
                    dIPlugin.setProperties(pluginProperties);
                    return dIPlugin;
                }
                return null;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new PluginInstantiationException(pluginProperties.getName(), reflectiveOperationException);
            }
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Class<?> clazz2 : classArray = constructor.getParameterTypes()) {
            try {
                linkedList.add(this.findDependency(clazz2));
            }
            catch (MissingDependencyException missingDependencyException) {
                throw new PluginInstantiationException(pluginProperties.getName(), missingDependencyException);
            }
        }
        try {
            Object reflectiveOperationException = constructor.newInstance(linkedList.toArray());
            if (!(reflectiveOperationException instanceof DIPlugin)) {
                return null;
            }
            DIPlugin dIPlugin = (DIPlugin)reflectiveOperationException;
            dIPlugin.setProperties(pluginProperties);
            return dIPlugin;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            if (reflectiveOperationException.getCause() != null) {
                logger.error((Object)(pluginProperties.getName() + " fails during instantiation!"));
                reflectiveOperationException.getCause().printStackTrace();
            }
            throw new PluginInstantiationException(pluginProperties.getName(), reflectiveOperationException);
        }
    }

    private Constructor<?> findInjectionPoint(Class<? extends IPlugin> clazz) {
        Constructor<?>[] constructorArray;
        for (Constructor<?> constructor : constructorArray = clazz.getConstructors()) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            return constructor;
        }
        return null;
    }
}

