/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.load;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.annotations.Provides;
import de.renew.plugin.di.FactoryDefinition;
import de.renew.plugin.di.ServiceContainer;
import de.renew.plugin.load.PluginInstantiationException;
import de.renew.plugin.load.PluginLoader;
import de.renew.plugin.load.SimplePluginLoader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public abstract class AbstractPluginLoader
implements PluginLoader {
    public static Logger logger = Logger.getLogger(SimplePluginLoader.class);
    protected final PluginClassLoader loader;
    protected final ServiceContainer container;

    public AbstractPluginLoader(PluginClassLoader pluginClassLoader, ServiceContainer serviceContainer) {
        this.loader = pluginClassLoader;
        this.container = serviceContainer;
    }

    public static URL[] unifyURL(URL uRL) {
        File file = null;
        try {
            file = new File(uRL.toURI());
        }
        catch (Exception exception) {
            logger.warn((Object)("Unable to search for JAR files in " + String.valueOf(uRL) + ": " + String.valueOf(exception)));
        }
        URL[] uRLArray = AbstractPluginLoader.getURLsFromDirectory(file);
        if (uRLArray == null || uRLArray.length == 0) {
            logger.warn((Object)("No JAR found in " + String.valueOf(uRL) + ", resorting to given URL."));
            return new URL[]{uRL};
        }
        return uRLArray;
    }

    private static URL[] getURLsFromDirectory(File file) {
        if (file == null) {
            return null;
        }
        if (file.getName().endsWith(".jar")) {
            try {
                Vector<URL> vector = new Vector<URL>();
                vector.add(file.toURI().toURL());
                String string = "jar:" + String.valueOf(file.toURI().toURL()) + "!/";
                JarFile jarFile = new JarFile(file);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!jarEntry.getName().startsWith("libs/") || !jarEntry.getName().endsWith(".jar")) continue;
                    vector.add(new URL(string + jarEntry.getName()));
                }
                return vector.toArray(new URL[vector.size()]);
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)("SimplePluginLoader: Could not convert to URL: " + String.valueOf(file) + " (" + malformedURLException.getMessage() + ")."));
            }
            catch (IOException iOException) {
                logger.error((Object)("Error while opening/reading jar file: " + String.valueOf(file)), (Throwable)iOException);
            }
        }
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        Vector<URL> vector = AbstractPluginLoader.getJarsRecursiveFromDir(file);
        return vector.toArray(new URL[vector.size()]);
    }

    private static Vector<URL> getJarsRecursiveFromDir(File file) {
        Vector<URL> vector = new Vector<URL>();
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".jar");
            }
        });
        if (fileArray == null) {
            return vector;
        }
        for (File file2 : fileArray) {
            if (file2.isFile()) {
                try {
                    vector.add(file2.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    logger.debug((Object)("Can't convert file location to URL: " + malformedURLException.getMessage()), (Throwable)malformedURLException);
                }
                continue;
            }
            if (!file2.isDirectory()) continue;
            vector.addAll(AbstractPluginLoader.getJarsRecursiveFromDir(file2));
        }
        return vector;
    }

    @Override
    public final IPlugin loadPlugin(PluginProperties pluginProperties) {
        URL uRL = pluginProperties.getURL();
        logger.debug((Object)(this.getClass().getSimpleName() + " loading from " + String.valueOf(pluginProperties.getURL())));
        URL[] uRLArray = AbstractPluginLoader.unifyURL(uRL);
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, this.loader.getURLs());
        for (URL uRL2 : uRLArray) {
            if (hashSet.contains(uRL2)) continue;
            this.loader.addURL(uRL2);
        }
        try {
            Class<? extends IPlugin> pluginInstantiationException = this.findMainClass(pluginProperties);
            if (pluginInstantiationException == null) {
                logger.debug((Object)"* no main class!");
                return new PluginAdapter(pluginProperties);
            }
            IPlugin iPlugin = this.createPlugin(pluginProperties, pluginInstantiationException);
            this.bindPluginServices(pluginInstantiationException, iPlugin);
            return iPlugin;
        }
        catch (PluginInstantiationException pluginInstantiationException) {
            logger.debug((Object)(this.getClass().getSimpleName() + ": " + pluginInstantiationException.getMessage()));
            if (logger.isTraceEnabled()) {
                pluginInstantiationException.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public final IPlugin loadPluginFromURL(URL uRL) {
        PluginProperties pluginProperties = new PluginProperties(uRL);
        try {
            InputStream inputStream = SimplePluginLoader.PluginConfigFinder.getConfigInputStream(uRL);
            pluginProperties.load(inputStream);
            return this.loadPlugin(pluginProperties);
        }
        catch (Exception exception) {
            logger.error((Object)("SimplePluginLoader.loadPluginFromURL: " + String.valueOf(exception)));
            return null;
        }
    }

    protected abstract IPlugin createPlugin(PluginProperties var1, Class<? extends IPlugin> var2) throws PluginInstantiationException;

    protected Class<? extends IPlugin> findMainClass(PluginProperties pluginProperties) {
        String string = pluginProperties.getProperty("mainClass");
        if (string == null) {
            return null;
        }
        try {
            logger.debug((Object)("* creating a " + string + " with cl " + String.valueOf(this.loader)));
            Class<?> clazz = this.loader.loadClass(string);
            if (clazz.getClassLoader() != this.loader) {
                logger.warn((Object)("system class loader was used to load " + String.valueOf(clazz) + "; it was probably in your classpath."));
                logger.warn((Object)"That might turn out as a problem.");
            }
            return clazz.asSubclass(IPlugin.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error((Object)classNotFoundException.getMessage());
            return null;
        }
        catch (ClassCastException classCastException) {
            logger.error((Object)classCastException.getMessage());
            return null;
        }
    }

    protected Collection<String> parseListString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>(stringTokenizer.countTokens());
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                vector.add(string2);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error((Object)("PluginLoader: " + String.valueOf(arrayIndexOutOfBoundsException) + " when parsing " + string + " as list!"));
        }
        return vector;
    }

    private void bindPluginServices(Class<? extends IPlugin> clazz, final IPlugin iPlugin) {
        this.container.set(clazz, iPlugin);
        logger.debug((Object)("Bound Service: " + String.valueOf(clazz)));
        for (final Method method : iPlugin.getClass().getMethods()) {
            if (method.getAnnotation(Provides.class) == null) continue;
            Class<?> clazz2 = method.getReturnType();
            this.container.addDefinition(new FactoryDefinition<Object>(clazz2, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return method.invoke((Object)iPlugin, new Object[0]);
                }
            }));
            logger.debug((Object)("Bound Service: " + clazz2.toString()));
        }
    }
}

