/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import CH.ifa.draw.DrawPlugin;
import de.renew.gui.logging.GuiAppender;
import de.renew.gui.logging.LoggerTableModel;
import de.renew.gui.logging.LoggingFrame;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LoggingController {
    private LoggingFrame frame;
    private LoggerTableModel currentLoggerTableModel;

    public LoggingController(final Set<LoggingController> set) {
        String[] stringArray = this.findSimulationLoggerNames();
        this.frame = new LoggingFrame(this, stringArray);
        DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().addFrame("Tools", (Frame)this.frame);
        final LoggingController loggingController = this;
        set.add(loggingController);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().removeFrame((Frame)LoggingController.this.frame);
                set.remove(loggingController);
                LoggingController.this.closeFrame();
            }
        });
        if (stringArray.length > 0) {
            this.changeLogger(stringArray[0]);
        }
    }

    public void setPermanentUpdate(boolean bl) {
        if (bl) {
            this.destruct();
            this.currentLoggerTableModel = new LoggerTableModel(this.frame.getSelectedLoggerName());
            this.frame.setTableModel(this.currentLoggerTableModel);
        }
        if (this.currentLoggerTableModel != null) {
            this.currentLoggerTableModel.setPermanentUpdate(bl);
        }
    }

    public void changeLogger(String string) {
        this.showLogger(string);
    }

    private String[] findSimulationLoggerNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = LogManager.getCurrentLoggers();
        while (enumeration.hasMoreElements()) {
            Logger logger = (Logger)enumeration.nextElement();
            if (!logger.getName().startsWith("simulation")) continue;
            Enumeration enumeration2 = logger.getAllAppenders();
            while (enumeration2.hasMoreElements()) {
                Object e = enumeration2.nextElement();
                if (!(e instanceof GuiAppender)) continue;
                vector.add(logger.getName());
            }
        }
        return vector.toArray(new String[0]);
    }

    private void showLogger(String string) {
        this.destruct();
        this.currentLoggerTableModel = new LoggerTableModel(string);
        this.frame.setTableModel(this.currentLoggerTableModel);
    }

    public void closeFrame() {
        this.frame.setVisible(false);
        this.frame.dispose();
        this.destruct();
    }

    private void destruct() {
        if (this.currentLoggerTableModel != null) {
            this.currentLoggerTableModel.removeAll();
            this.currentLoggerTableModel = null;
        }
    }
}

