/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.creator;

import de.renew.gui.pnml.converter.GraphicConverter;
import de.renew.gui.pnml.creator.PNMLCreator;
import java.awt.Color;
import org.w3c.dom.Element;

public class GraphicCreator {
    private PNMLCreator _pnmlCreator;
    private Element _element;
    private Element line;

    public GraphicCreator(PNMLCreator pNMLCreator) {
        this._element = pNMLCreator.createElement("graphics");
        this._pnmlCreator = pNMLCreator;
    }

    protected Element getElement() {
        return this._element;
    }

    public void addPosition(int n, int n2) {
        Element element = this._pnmlCreator.createElement("position");
        element.setAttribute("x", String.valueOf(n));
        element.setAttribute("y", String.valueOf(n2));
        this._element.appendChild(element);
    }

    public void addOffset(int n, int n2) {
        Element element = this._pnmlCreator.createElement("offset");
        element.setAttribute("x", String.valueOf(n));
        element.setAttribute("y", String.valueOf(n2));
        this._element.appendChild(element);
    }

    public void addDimension(int n, int n2) {
        Element element = this._pnmlCreator.createElement("dimension");
        element.setAttribute("x", String.valueOf(n));
        element.setAttribute("y", String.valueOf(n2));
        this._element.appendChild(element);
    }

    public void addFill(Color color) {
        Element element = this._pnmlCreator.createElement("fill");
        element.setAttribute("color", "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")");
        this._element.appendChild(element);
    }

    public void addLineColor(Color color) {
        this.getLineElement().setAttribute("color", "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")");
    }

    public void addLineStyle(String string) {
        this.getLineElement().setAttribute("style", GraphicConverter.instance().parseRenewLineStyle(string));
    }

    public void addLine() {
        this._element.appendChild(this.getLineElement());
    }

    private Element getLineElement() {
        if (this.line == null) {
            this.line = this._pnmlCreator.createElement("line");
        }
        return this.line;
    }
}

