/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import de.renew.gui.Breakpoint;
import de.renew.gui.BreakpointManager;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.PlaceInstanceFigure;
import de.renew.gui.TokenBagFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.TransitionInstanceFigure;
import de.renew.net.Net;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import de.renew.remote.PlaceInstanceAccessorImpl;
import de.renew.remote.TransitionInstanceAccessorImpl;
import java.util.Vector;

public class ToggleBreakpointCommand
extends UndoableCommand {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int GLOBAL = 10;
    public static final int LOCAL = 11;
    public static final int PRESET = 12;
    private BreakpointManager manager;
    private int op;
    private int context;
    private int breakpointMode;

    public ToggleBreakpointCommand(String string, BreakpointManager breakpointManager, int n, int n2) {
        this(string, breakpointManager, n, n2, 0);
    }

    public ToggleBreakpointCommand(String string, BreakpointManager breakpointManager, int n, int n2, int n3) {
        super(string);
        this.manager = breakpointManager;
        this.op = n;
        this.context = n2;
        this.breakpointMode = n3;
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        Drawing drawing = this.getEditor().drawing();
        DrawingView drawingView = this.getEditor().view();
        if (drawingView.selectionCount() <= 0) {
            return false;
        }
        if (drawingView.selectionCount() > 1) {
            if (this.context == 12) {
                return drawing instanceof CPNDrawing;
            }
            return drawing instanceof CPNInstanceDrawing && ((CPNInstanceDrawing)drawing).isLocal();
        }
        Figure figure = (Figure)drawingView.selectionElements().nextElement();
        if (this.context == 12) {
            if (figure instanceof TransitionFigure) {
                return BreakpointManager.isValidTransitionMode(this.breakpointMode);
            }
            if (figure instanceof PlaceFigure) {
                return BreakpointManager.isValidPlaceMode(this.breakpointMode);
            }
        } else if (drawing instanceof CPNInstanceDrawing && ((CPNInstanceDrawing)drawing).isLocal()) {
            if (figure instanceof TransitionInstanceFigure) {
                return BreakpointManager.isValidTransitionMode(this.breakpointMode);
            }
            if (figure instanceof PlaceInstanceFigure || figure instanceof TokenBagFigure) {
                return BreakpointManager.isValidPlaceMode(this.breakpointMode);
            }
        }
        return false;
    }

    public boolean executeUndoable() {
        DrawingView drawingView = this.getEditor().view();
        int n = 0;
        Vector<StringBuffer> vector = new Vector<StringBuffer>();
        if (this.isExecutable()) {
            StringBuffer stringBuffer;
            if (!super.isExecutable()) {
                return false;
            }
            FigureEnumeration figureEnumeration = drawingView.selectionElements();
            while (figureEnumeration.hasMoreElements()) {
                Breakpoint breakpoint;
                Net net;
                Transition transition;
                TransitionInstance transitionInstance;
                Figure figure = figureEnumeration.nextFigure();
                if (this.context == 12) {
                    if (figure instanceof TransitionFigure) {
                        switch (this.op) {
                            case 1: {
                                if (!BreakpointManager.isValidTransitionMode(this.breakpointMode)) break;
                                figure.setAttribute("BreakpointMode", (Object)new Integer(this.breakpointMode));
                                ++n;
                                break;
                            }
                            case 2: {
                                if (figure.getAttribute("BreakpointMode") == null) break;
                                figure.setAttribute("BreakpointMode", null);
                                ++n;
                            }
                        }
                        continue;
                    }
                    if (!(figure instanceof PlaceFigure)) continue;
                    switch (this.op) {
                        case 1: {
                            if (!BreakpointManager.isValidPlaceMode(this.breakpointMode)) break;
                            figure.setAttribute("BreakpointMode", (Object)new Integer(this.breakpointMode));
                            ++n;
                            break;
                        }
                        case 2: {
                            if (figure.getAttribute("BreakpointMode") == null) break;
                            figure.setAttribute("BreakpointMode", null);
                            ++n;
                        }
                    }
                    continue;
                }
                if (figure instanceof TransitionInstanceFigure) {
                    stringBuffer = ((TransitionInstanceFigure)figure).getInstance();
                    if (!(stringBuffer instanceof TransitionInstanceAccessorImpl)) {
                        throw new IllegalStateException("Only the local simulation may set breakpoints");
                    }
                    transitionInstance = ((TransitionInstanceAccessorImpl)stringBuffer).getTransitionInstance();
                    transition = transitionInstance.getTransition();
                    net = transitionInstance.getNetInstance().getNet();
                    switch (this.op) {
                        case 1: {
                            breakpoint = this.context == 10 ? this.manager.createTransitionBreakpoint(transition, this.breakpointMode, net) : this.manager.createTransitionInstanceBreakpoint(transitionInstance, this.breakpointMode);
                            if (breakpoint == null) break;
                            ++n;
                            break;
                        }
                        case 2: {
                            if (this.context == 10) {
                                n += this.manager.deleteBreakpointsAt(transition);
                                break;
                            }
                            n += this.manager.deleteBreakpointsAt(transitionInstance);
                        }
                    }
                    continue;
                }
                stringBuffer = null;
                if (figure instanceof PlaceInstanceFigure) {
                    stringBuffer = ((PlaceInstanceFigure)figure).getInstance();
                } else if (figure instanceof TokenBagFigure) {
                    stringBuffer = ((TokenBagFigure)figure).getPlaceInstance();
                }
                if (vector.contains(stringBuffer)) {
                    stringBuffer = null;
                }
                if (stringBuffer == null) continue;
                if (!(stringBuffer instanceof PlaceInstanceAccessorImpl)) {
                    throw new IllegalStateException("Only the local simulation may set breakpoints");
                }
                transitionInstance = ((PlaceInstanceAccessorImpl)stringBuffer).getPlaceInstance();
                vector.addElement(stringBuffer);
                transition = transitionInstance.getPlace();
                net = transitionInstance.getNetInstance().getNet();
                switch (this.op) {
                    case 1: {
                        breakpoint = this.context == 10 ? this.manager.createPlaceBreakpoint((Place)transition, this.breakpointMode, net) : this.manager.createPlaceInstanceBreakpoint((PlaceInstance)transitionInstance, this.breakpointMode);
                        if (breakpoint == null) break;
                        ++n;
                        break;
                    }
                    case 2: {
                        if (this.context == 10) {
                            n += this.manager.deleteBreakpointsAt(transition);
                            break;
                        }
                        n += this.manager.deleteBreakpointsAt(transitionInstance);
                    }
                }
            }
            drawingView.checkDamage();
            stringBuffer = new StringBuffer();
            if (n == 1) {
                stringBuffer.append("1 breakpoint");
            } else {
                stringBuffer.append(n + " breakpoints");
            }
            switch (this.op) {
                case 1: {
                    stringBuffer.append(" set.");
                    break;
                }
                case 2: {
                    stringBuffer.append(" cleared.");
                }
            }
            this.getEditor().showStatus(stringBuffer.toString());
            if (this.context == 12 && n > 0) {
                return true;
            }
        }
        return false;
    }
}

