/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import de.renew.gui.CPNDrawing;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.awt.EventQueue;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LoadFileFromJarHelper {
    private static Logger logger = Logger.getLogger(LoadFileFromJarHelper.class);
    private static final String RNW_IMG_PROPERTY = "de.renew.jars.containing.rnw.files";
    private static String extensionUsed;

    public static synchronized BufferedInputStream getImageFromJar(String string, String ... stringArray) {
        try {
            logger.trace((Object)("LoadFileFromJarHelper.getImageFromJar: FILENAME " + string));
            extensionUsed = null;
            JarFile jarFile = LoadFileFromJarHelper.getJarFileContainingFile(string, stringArray);
            if (jarFile == null) {
                logger.warn((Object)("1. Image with name " + string + " not found"));
                return null;
            }
            ZipEntry zipEntry = jarFile.getEntry(string + "." + extensionUsed);
            if (zipEntry == null) {
                logger.warn((Object)("2. Image with name " + string + " not found"));
                return null;
            }
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            return new BufferedInputStream(inputStream);
        }
        catch (IOException iOException) {
            logger.warn((Object)iOException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            logger.warn((Object)nullPointerException.getMessage());
        }
        return null;
    }

    public static synchronized void loadRnwFileFromJar(String string) {
        ZipEntry zipEntry;
        extensionUsed = null;
        Drawing drawing = null;
        InputStream inputStream = null;
        JarFile jarFile = null;
        if (string != null && string.endsWith(".rnw")) {
            string = string.replace(".rnw", "");
        }
        try {
            jarFile = LoadFileFromJarHelper.getJarFileContainingFile(string, "rnw");
            zipEntry = jarFile.getEntry(string + ".rnw");
            inputStream = jarFile.getInputStream(zipEntry);
            drawing = DrawingFileHelper.loadDrawing((InputStream)inputStream, (String)string);
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to load drawing " + string), (Throwable)exception);
        }
        if (drawing != null && drawing instanceof CPNDrawing && (zipEntry = DrawPlugin.getCurrent().getIOHelper()) != null && jarFile != null) {
            ZipEntry zipEntry2 = jarFile.getEntry(string + ".rnw");
            InputStream inputStream2 = null;
            try {
                inputStream2 = jarFile.getInputStream(zipEntry2);
            }
            catch (IOException iOException) {
                logger.error((Object)("Failed to get InputStream for " + string + ".rnw from jar file"), (Throwable)iOException);
            }
            InputStream inputStream3 = inputStream2;
            String string2 = string;
            if (SwingUtilities.isEventDispatchThread()) {
                try {
                    zipEntry.loadAndOpenDrawings(inputStream3, string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){
                        final /* synthetic */ IOHelper val$ioHelper;
                        final /* synthetic */ InputStream val$fstream;
                        final /* synthetic */ String val$fName;
                        {
                            this.val$ioHelper = iOHelper;
                            this.val$fstream = inputStream;
                            this.val$fName = string;
                        }

                        @Override
                        public void run() {
                            try {
                                this.val$ioHelper.loadAndOpenDrawings(this.val$fstream, this.val$fName);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                fileNotFoundException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    logger.trace((Object)"HelperGui.test : Caught interrupt while loading drawing", (Throwable)interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    logger.trace((Object)"HelperGui.test : Caught InvocationTargetException while loading drawing", (Throwable)invocationTargetException);
                }
            }
        }
    }

    private static synchronized File findJarFile(String string) {
        IPlugin iPlugin = PluginManager.getInstance().getPluginByName(string);
        if (iPlugin != null) {
            try {
                logger.debug((Object)("FOUND jar file for pluginName " + string));
                return new File(iPlugin.getProperties().getURL().toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.error((Object)("Error while creating File for plugin " + string + " of URL " + String.valueOf(iPlugin.getProperties().getURL())), (Throwable)uRISyntaxException);
            }
        }
        logger.warn((Object)("No plugin found with name " + string));
        return null;
    }

    private static synchronized JarFile getJarFileContainingFile(String string, String ... stringArray) throws FileNotFoundException, IOException {
        if (stringArray == null || stringArray.length == 0) {
            throw new NullPointerException("No extension(s) given");
        }
        String string2 = PluginProperties.getUserProperties().getProperty(RNW_IMG_PROPERTY);
        if (string2 == null) {
            logger.warn((Object)"Property de.renew.jars.containing.rnw.files not set!");
            return null;
        }
        String[] stringArray2 = string2.split(":");
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            File file = LoadFileFromJarHelper.findJarFile(stringArray2[i]);
            if (file == null) continue;
            JarFile jarFile = new JarFile(file);
            ZipEntry zipEntry = null;
            for (String string3 : stringArray) {
                zipEntry = jarFile.getEntry(string + "." + string3);
                if (zipEntry == null) continue;
                extensionUsed = string3;
                break;
            }
            if (zipEntry == null) continue;
            logger.debug((Object)("Found ZIPEntry which contains file " + string));
            return jarFile;
        }
        throw new FileNotFoundException("File " + string + " not found in any of the given plugins " + string2);
    }
}

