/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.wizard;

import de.renew.refactoring.wizard.WizardPage;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public abstract class ProgressBarWizardPage<T>
extends WizardPage {
    private JProgressBar _progressBar;
    private JLabel _statusLabel;
    private boolean _isInProgress = true;

    public ProgressBarWizardPage(String string) {
        super(string);
        JPanel jPanel = this.getPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        this._progressBar = new JProgressBar();
        jPanel.add(this._progressBar);
        this._statusLabel = new JLabel();
        jPanel.add(this._statusLabel);
    }

    public void setProgress(int n) {
        this._progressBar.setValue(n);
    }

    public void setStatus(String string) {
        this._statusLabel.setText(string);
    }

    public void setStatus(String string, String string2) {
        this.setStatus("<html>" + string + ": <i>" + string2 + "</i></html>");
    }

    public boolean isInProgress() {
        return this._isInProgress;
    }

    public final void done(T t) {
        this._isInProgress = false;
        JPanel jPanel = this.getPanel();
        this.restoreDefaultLayout();
        jPanel.remove(this._progressBar);
        jPanel.remove(this._statusLabel);
        jPanel.repaint();
        jPanel.revalidate();
        this._progressBar = null;
        this._statusLabel = null;
        this.progressDone(t);
    }

    protected abstract void progressDone(T var1);
}

