/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.search.range;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.util.PathEntry;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class NetpathFiles {
    private static Logger logger = Logger.getLogger(NetpathFiles.class);

    private NetpathFiles() {
    }

    public static List<File> files(String string, String string2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (PathEntry pathEntry : NetpathFiles.netPathEntries()) {
            logger.debug((Object)("Processing net path entry: " + pathEntry.path));
            File file = new File(pathEntry.path);
            arrayList.addAll(NetpathFiles.listFiles(file, string));
        }
        return arrayList;
    }

    public static List<File> files(List<String> list, String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : list) {
            arrayList.addAll(NetpathFiles.files(string2, string));
        }
        return arrayList;
    }

    private static List<PathEntry> netPathEntries() {
        IPlugin iPlugin = (IPlugin)PluginManager.getInstance().getPluginsProviding("de.renew.simulator").iterator().next();
        PathEntry[] pathEntryArray = StringUtil.canonizePaths((String[])StringUtil.splitPaths((String)iPlugin.getProperties().getProperty("de.renew.netPath")));
        ArrayList<PathEntry> arrayList = new ArrayList<PathEntry>(pathEntryArray.length);
        for (int i = 0; i < pathEntryArray.length; ++i) {
            logger.debug((Object)("Processing net path entry: " + pathEntryArray[i].path));
            if (pathEntryArray[i].isClasspathRelative) continue;
            arrayList.add(pathEntryArray[i]);
        }
        return arrayList;
    }

    private static List<File> listFiles(File file, final String string) {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return StringUtil.getExtension((String)string2).toLowerCase().equals(string.toLowerCase());
            }
        });
        if (fileArray == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(fileArray);
    }
}

