/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamevariable;

import CH.ifa.draw.framework.Drawing;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingView;
import de.renew.refactoring.inline.SingleInlineUndoableCommand;
import de.renew.refactoring.parse.DeclarationFinder;
import de.renew.refactoring.parse.JNPVariableParser;
import de.renew.refactoring.renamevariable.NoVariableSelectedException;
import de.renew.refactoring.renamevariable.RenameVariableInlineController;
import de.renew.refactoring.renamevariable.RenameVariableSelectionChecker;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RenameVariableCommand
extends SingleInlineUndoableCommand {
    private static Logger logger = Logger.getLogger(RenameVariableCommand.class);
    private static final String COMMAND_NAME = "Rename variable...";

    public RenameVariableCommand() {
        super(COMMAND_NAME);
    }

    protected boolean executeUndoable() {
        Drawing drawing = this.getEditor().drawing();
        String string = new DeclarationFinder(drawing).declarationText();
        CPNDrawingView cPNDrawingView = (CPNDrawingView)this.getEditor().view();
        try {
            RenameVariableInlineController renameVariableInlineController = new RenameVariableInlineController(new JNPVariableParser(string), cPNDrawingView);
            this.setInline(renameVariableInlineController);
        }
        catch (NoVariableSelectedException noVariableSelectedException) {
            this.getEditor().showStatus("There is a syntax error or no variable is selected.");
            return false;
        }
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        Drawing drawing = this.getEditor().drawing();
        if (!(drawing instanceof CPNDrawing)) {
            return false;
        }
        boolean bl = FormalismPlugin.getCurrent().getCompiler().equals("Java Net Compiler");
        if (!bl) {
            return false;
        }
        Vector vector = this.getEditor().view().selection();
        RenameVariableSelectionChecker renameVariableSelectionChecker = new RenameVariableSelectionChecker(vector, null);
        if (renameVariableSelectionChecker.isTextFigureSelected()) {
            return true;
        }
        DeclarationFinder declarationFinder = new DeclarationFinder(drawing);
        return declarationFinder.hasDeclarationFigure();
    }
}

