/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse.name;

import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.name.NameFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RegexNameFinder
implements NameFinder {
    private static Logger logger = Logger.getLogger(RegexNameFinder.class);
    private final String _name;
    private final Pattern _namePattern;

    public RegexNameFinder(String string) {
        this(string, null);
    }

    public RegexNameFinder(String string, String string2) {
        this(string, string2, string2);
    }

    public RegexNameFinder(String string, String string2, String string3) {
        this._name = string;
        this._namePattern = Pattern.compile("(^|[^\\w" + string2 + "])" + string + "($|[^\\w" + string3 + "])");
    }

    @Override
    public boolean find(String string) {
        return this._namePattern.matcher(string).find();
    }

    @Override
    public List<StringMatch> listOfMatches(String string) {
        Matcher matcher = this._namePattern.matcher(string);
        ArrayList<StringMatch> arrayList = new ArrayList<StringMatch>();
        while (matcher.find()) {
            String string2 = string.substring(matcher.start(), matcher.end());
            int n = matcher.start() + string2.indexOf(this._name);
            int n2 = n + this._name.length();
            String string3 = string.substring(n, n2);
            arrayList.add(new StringMatch(string3, n, n2));
        }
        return arrayList;
    }
}

