/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.match;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import de.renew.refactoring.match.Match;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.util.StringHelper;

public class TextFigureMatch
extends Match {
    private final Drawing _drawing;
    private final TextFigure _textFigure;

    protected TextFigureMatch(Drawing drawing, TextFigure textFigure, StringMatch stringMatch) {
        super(stringMatch);
        this._drawing = drawing;
        this._textFigure = textFigure;
    }

    public TextFigure getTextFigure() {
        return this._textFigure;
    }

    public Drawing getDrawing() {
        return this._drawing;
    }

    public String getText() {
        return this._textFigure.getText();
    }

    public String toString() {
        return this.getMatch();
    }

    public String matchWithContext() {
        return this.matchWithContext(40);
    }

    public String matchWithContext(int n) {
        return StringHelper.substringWithContext(this.getText(), this.getStart(), this.getEnd(), n);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this._drawing.hashCode() ^ this._textFigure.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof TextFigureMatch) {
            TextFigureMatch textFigureMatch = (TextFigureMatch)object;
            return this.getDrawing() == textFigureMatch.getDrawing() && this.getTextFigure() == textFigureMatch.getTextFigure();
        }
        return false;
    }
}

