/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.edit;

import de.renew.refactoring.edit.IteratorEditor;
import de.renew.refactoring.edit.TextFigureMatchSorter;
import de.renew.refactoring.match.TextFigureMatch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class TextFigureMatchEditor<T extends TextFigureMatch, R>
extends IteratorEditor<T, R> {
    private static Logger logger = Logger.getLogger(TextFigureMatchEditor.class);
    private final Map<T, String> _previousTexts;

    public TextFigureMatchEditor(List<T> list) {
        super(new TextFigureMatchSorter<T>().sorted(list));
        this._previousTexts = this.previousTexts(list);
    }

    @Override
    public String getCurrentEditString() {
        return ((TextFigureMatch)this.getCurrentEdit()).getDrawing().getName();
    }

    protected void changeText(T t, String string) {
        ((TextFigureMatch)t).getTextFigure().setText(string);
        ((TextFigureMatch)t).getTextFigure().changed();
        ((TextFigureMatch)t).getDrawing().checkDamage();
    }

    private Map<T, String> previousTexts(List<T> list) {
        HashMap<TextFigureMatch, String> hashMap = new HashMap<TextFigureMatch, String>();
        for (TextFigureMatch textFigureMatch : list) {
            hashMap.put(textFigureMatch, textFigureMatch.getText());
        }
        return hashMap;
    }

    public void restorePreviousTexts() {
        for (TextFigureMatch textFigureMatch : this._previousTexts.keySet()) {
            String string = this._previousTexts.get(textFigureMatch);
            logger.debug((Object)("Restoring previous text: " + string));
            this.changeText(textFigureMatch, string);
        }
    }
}

