/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.DoublePoint;
import java.awt.Point;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BSpline {
    public static Logger logger = Logger.getLogger(BSpline.class);
    public static final int DEFSEGMENTS = 15;
    public static final int DEFDEGREE = 2;
    private Vector<DoublePoint> curvepoints = null;
    private Vector<Point> curvepointsInt = null;
    private boolean curvepointsValid = false;
    private Vector<Point> controlpoints = null;
    private int segments;
    private int degree;

    public BSpline() {
    }

    public BSpline(Vector<Point> vector) {
        this.BSplineHelper(vector, 15, 2);
    }

    public BSpline(Vector<Point> vector, int n) {
        this.BSplineHelper(vector, n, 2);
    }

    public BSpline(Vector<Point> vector, int n, int n2) {
        this.BSplineHelper(vector, n, n2);
    }

    private void BSplineHelper(Vector<Point> vector, int n, int n2) {
        this.segments = n;
        this.degree = n2;
        this.setVector(vector);
        this.invalidatePointCache();
    }

    public void setSegments(int n) {
        if (this.segments != n) {
            this.segments = n;
            this.invalidatePointCache();
        }
    }

    public void setDegree(int n) {
        if (this.degree != n) {
            this.degree = n;
            this.invalidatePointCache();
        }
    }

    public void setPoints(Vector<Point> vector) {
        if (this.isPointCacheValid()) {
            if (!this.theSame(vector)) {
                this.setVector(vector);
                this.invalidatePointCache();
            }
        } else {
            this.setVector(vector);
        }
    }

    public int getSegments() {
        return this.segments;
    }

    public int getDegree() {
        return this.degree;
    }

    public Vector<Point> getCurvepointsInt() {
        this.updatePointCache();
        return this.curvepointsInt;
    }

    public Vector<DoublePoint> getCurvepointsDouble() {
        this.updatePointCache();
        return this.curvepoints;
    }

    public int lineSegment(int n) {
        return (n - 1) / this.segments;
    }

    private void invalidatePointCache() {
        this.curvepointsValid = false;
    }

    private void updatePointCache() {
        if (!this.isPointCacheValid()) {
            this.curvepoints = BSpline.calculateSpline(this.degree, this.segments, this.controlpoints);
            this.curvepointsInt = DoublePoint.convertDoublePointVector(this.curvepoints);
            this.curvepointsValid = true;
        }
    }

    private boolean isPointCacheValid() {
        return this.curvepointsValid;
    }

    private void setVector(Vector<Point> vector) {
        Vector<Point> vector2 = new Vector<Point>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            vector2.addElement(new Point(vector.elementAt(i)));
        }
        this.controlpoints = vector2;
    }

    private boolean theSame(Vector<Point> vector) {
        if (vector == null || this.controlpoints == null) {
            return false;
        }
        if (vector.size() != this.controlpoints.size()) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Point point;
            Point point2 = vector.elementAt(i);
            if (point2.equals(point = this.controlpoints.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Vector<DoublePoint> calculateSpline(int n, int n2, Vector<Point> vector) {
        int n3;
        int n4 = vector.size();
        if (n4 < (n3 = n) + 1) {
            n3 = n4 - 1;
        }
        if (n4 > 2) {
            int n5 = (n4 - 1) * n2;
            Vector<DoublePoint> vector2 = new Vector<DoublePoint>();
            int n6 = n4 + n3;
            double[] dArray = BSpline.knotvector(n6, n3);
            double d = 1.0 / (double)n5;
            for (int i = 0; i < n5; ++i) {
                double d2 = (double)i * d;
                DoublePoint doublePoint = BSpline.sppoint(d2, n3, vector, dArray);
                vector2.addElement(doublePoint);
            }
            vector2.addElement(new DoublePoint(vector.lastElement()));
            return vector2;
        }
        return DoublePoint.convertPointVector(vector);
    }

    private static double[] knotvector(int n, int n2) {
        int n3;
        int n4 = n + 1;
        double[] dArray = new double[n4];
        int n5 = n - n2 * 2;
        for (n3 = 0; n3 < n5; ++n3) {
            dArray[n3 + n2] = 1.0 / (double)n5 * (double)n3;
        }
        for (n3 = 0; n3 < n2 + 1; ++n3) {
            dArray[n3] = 0.0;
            dArray[n4 - 1 - n3] = 1.0;
        }
        return dArray;
    }

    private static double div0(double d, double d2) {
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    private static double[] weightDyn(int n, int n2, int n3, double[] dArray, double d) {
        int n4;
        double[] dArray2 = new double[n2 + 1 + n3];
        for (n4 = n; n4 <= n2 + n3; ++n4) {
            dArray2[n4] = dArray[n4] <= d && d < dArray[n4 + 1] ? 1.0 : 0.0;
        }
        for (n4 = 1; n4 <= n3; ++n4) {
            for (int i = n; i <= n2 + n3 - n4; ++i) {
                dArray2[i] = BSpline.div0((d - dArray[i]) * dArray2[i], dArray[i + n4] - dArray[i]) + BSpline.div0((dArray[i + n4 + 1] - d) * dArray2[i + 1], dArray[i + n4 + 1] - dArray[i + 1]);
            }
        }
        return dArray2;
    }

    public static DoublePoint sppoint(double d, int n, Vector<Point> vector, double[] dArray) {
        int n2;
        int n3 = vector.size();
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = 0;
        for (n2 = 1; n2 < n3; ++n2) {
            if (!(dArray[n2] <= d)) continue;
            n4 = n2;
        }
        n2 = n4;
        for (int i = n4; i >= 0; --i) {
            if (!(d < dArray[i + n + 1])) continue;
            n2 = i;
        }
        double[] dArray2 = BSpline.weightDyn(n2, n4, n, dArray, d);
        for (int i = 0; i < n3; ++i) {
            if (!(dArray[i] <= d) || !(d < dArray[i + n + 1])) continue;
            double d4 = dArray2[i];
            Point point = vector.elementAt(i);
            d2 += d4 * (double)point.x;
            d3 += d4 * (double)point.y;
        }
        return new DoublePoint(d2, d3);
    }
}

