/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.util.AutosaveSaver;
import de.renew.util.Scheduler;
import de.renew.util.StringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class AutosaveTask
implements Runnable {
    public static Logger logger = Logger.getLogger(AutosaveTask.class);
    private Drawing drawing;
    private long lastSaved;
    private long interval;
    private File autosaveFilename = null;
    private AutosaveSaver saver;

    public AutosaveTask(AutosaveSaver autosaveSaver, Drawing drawing, long l) {
        this.saver = autosaveSaver;
        this.drawing = drawing;
        this.interval = l;
        this.reset();
        Scheduler.instance().executeIn((Runnable)this, l);
    }

    private void touch(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.interval = 0L;
            logger.debug((Object)("Autosave of drawing " + this.drawing.getName() + " cancelled: " + String.valueOf(iOException)));
        }
    }

    public synchronized void reset() {
        this.lastSaved = System.currentTimeMillis();
    }

    public synchronized void terminate() {
        this.interval = 0L;
        Scheduler.instance().cancel((Runnable)this);
        if (this.autosaveFilename != null && this.autosaveFilename.exists()) {
            logger.debug((Object)("Deleting autosave copy " + String.valueOf(this.autosaveFilename) + "..."));
            this.autosaveFilename.delete();
        }
    }

    @Override
    public synchronized void run() {
        if (this.interval > 0L) {
            long l = System.currentTimeMillis();
            long l2 = this.lastSaved + this.interval - l;
            if (l2 <= 0L) {
                if (this.drawing.isModified()) {
                    Serializable serializable;
                    if (this.autosaveFilename == null) {
                        serializable = this.drawing.getFilename();
                        if (serializable != null) {
                            this.autosaveFilename = new File(StringUtil.stripFilenameExtension((String)serializable.getPath()) + ".aut");
                        }
                        if (this.autosaveFilename != null && !this.autosaveFilename.exists()) {
                            this.touch(this.autosaveFilename);
                        } else {
                            this.autosaveFilename = null;
                            for (int i = 0; i < 25 && this.autosaveFilename == null && this.interval > 0L; ++i) {
                                int n = (int)Math.floor(Math.random() * 100000.0);
                                File file = new File("rnw" + n + ".aut");
                                try {
                                    if (!file.createNewFile()) continue;
                                    this.autosaveFilename = file;
                                    continue;
                                }
                                catch (IOException iOException) {
                                    this.interval = 0L;
                                    logger.debug((Object)("Autosave of drawing " + this.drawing.getName() + " cancelled: " + String.valueOf(iOException)));
                                }
                            }
                        }
                    }
                    if (this.interval > 0L && this.autosaveFilename != null) {
                        serializable = this.drawing.displayBox();
                        Dimension dimension = new Dimension(((Rectangle)serializable).width + ((Rectangle)serializable).x + 200, ((Rectangle)serializable).height + ((Rectangle)serializable).y + 200);
                        try {
                            logger.debug((Object)("Autosaving drawing " + this.drawing.getName() + " to " + String.valueOf(this.autosaveFilename) + "..."));
                            this.saver.saveAutosaveFile(this.drawing, this.autosaveFilename, new Point(), dimension);
                        }
                        catch (IOException iOException) {
                            this.interval = 0L;
                            logger.debug((Object)("Autosave of drawing " + this.drawing.getName() + " cancelled: " + String.valueOf(iOException)));
                        }
                    }
                }
                this.reset();
            }
            if (this.interval > 0L) {
                Scheduler.instance().executeAt((Runnable)this, this.lastSaved + this.interval);
            }
        }
    }
}

