/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureFilter;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.FilteredFigureEnumerator;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public class SpreadCommand
extends UndoableCommand {
    public static final int LEFTS = 0;
    public static final int CENTERS = 1;
    public static final int RIGHTS = 2;
    public static final int TOPS = 3;
    public static final int MIDDLES = 4;
    public static final int BOTTOMS = 5;
    public static final int HORIZONTAL_DISTANCE = 6;
    public static final int VERTICAL_DISTANCE = 7;
    public static final int DIAGONAL_CENTERS = 8;
    private static final int DIAGONAL_DISTANCE = 9;
    private int fOp;

    public SpreadCommand(String string, int n) {
        super(string);
        this.fOp = n;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 2;
    }

    @Override
    public boolean executeUndoable() {
        if (this.isExecutable()) {
            int n;
            Object object;
            Object object2;
            Iterator iterator;
            if (!super.isExecutable()) {
                return false;
            }
            DrawingView drawingView = this.getEditor().view();
            FigureEnumeration figureEnumeration = drawingView.selectionElements();
            figureEnumeration = new FilteredFigureEnumerator(figureEnumeration, new ConnectionFilter());
            LinkedList<SortPair> linkedList = new LinkedList<SortPair>();
            Rectangle rectangle = null;
            while (figureEnumeration.hasMoreElements()) {
                SortPair sortPair2 = new SortPair(this.fOp, figureEnumeration.nextFigure());
                if (rectangle == null) {
                    rectangle = new Rectangle(sortPair2.hotspot);
                } else {
                    rectangle.add(sortPair2.hotspot);
                }
                linkedList.add(0, sortPair2);
            }
            if (linkedList.size() < 3) {
                return false;
            }
            if (this.fOp != 8 && this.fOp != 9) {
                Collections.sort(linkedList, new HotspotComparator(this.fOp));
            } else {
                Point point = Geom.center(rectangle);
                Collections.sort(linkedList, new DistanceComparator(point));
                iterator = linkedList.iterator();
                SortPair sortPair = (SortPair)iterator.next();
                object2 = sortPair;
                object = sortPair;
                if (rectangle != null) {
                    n = (rectangle.width > rectangle.height ? rectangle.width : rectangle.height) / 2;
                    long l = n * n;
                    long l2 = 0L;
                    long l3 = 0L;
                    while (iterator.hasNext() && ((SortPair)object).distance2(point) >= l) {
                        object = (SortPair)iterator.next();
                        l3 = ((SortPair)object).distance2(sortPair.hotspot);
                        if (l2 >= l3) continue;
                        l2 = l3;
                        object2 = object;
                    }
                    Collections.sort(linkedList, new ProjectionComparator(sortPair.hotspot, ((SortPair)object2).hotspot));
                }
            }
            int n2 = 0;
            int n3 = 0;
            n = 0;
            int n4 = linkedList.size() - 1;
            iterator = linkedList.iterator();
            switch (this.fOp) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    n2 = ((SortPair)linkedList.get((int)n4)).hotspot.x - ((SortPair)linkedList.get((int)n)).hotspot.x;
                    n3 = ((SortPair)linkedList.get((int)n4)).hotspot.y - ((SortPair)linkedList.get((int)n)).hotspot.y;
                    break;
                }
                case 6: 
                case 7: {
                    object2 = ((SortPair)iterator.next()).figure.displayBox();
                    while (iterator.hasNext()) {
                        object = ((SortPair)iterator.next()).figure.displayBox();
                        n2 += ((Rectangle)object).x - ((Rectangle)object2).x - ((Rectangle)object2).width;
                        n3 += ((Rectangle)object).y - ((Rectangle)object2).y - ((Rectangle)object2).height;
                        object2 = object;
                    }
                    break;
                }
                case 9: {
                    n2 = ((SortPair)linkedList.get((int)n4)).hotspot.x - ((SortPair)linkedList.get((int)n)).hotspot.x;
                    n3 = ((SortPair)linkedList.get((int)n4)).hotspot.y - ((SortPair)linkedList.get((int)n)).hotspot.y;
                    object2 = ((SortPair)iterator.next()).figure.displayBox();
                    while (iterator.hasNext()) {
                        object = ((SortPair)iterator.next()).figure.displayBox();
                        n2 -= ((Rectangle)object2).width;
                        n3 -= ((Rectangle)object2).height;
                        object2 = object;
                    }
                    break;
                }
            }
            Point point = null;
            Point point2 = ((SortPair)linkedList.get((int)0)).hotspot;
            int n5 = 0;
            int n6 = linkedList.size() - 1;
            SortPair sortPair = null;
            for (SortPair sortPair2 : linkedList) {
                switch (this.fOp) {
                    case 0: 
                    case 1: 
                    case 2: {
                        point = new Point(point2.x + n2 * n5 / n6, sortPair2.hotspot.y);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        point = new Point(sortPair2.hotspot.x, point2.y + n3 * n5 / n6);
                        break;
                    }
                    case 8: {
                        point = new Point(point2.x + n2 * n5 / n6, point2.y + n3 * n5 / n6);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 9: {
                        if (sortPair != null) {
                            int n7 = n2 * n5 / n6 - n2 * (n5 - 1) / n6;
                            int n8 = n3 * n5 / n6 - n3 * (n5 - 1) / n6;
                            switch (this.fOp) {
                                case 6: {
                                    point = new Point(sortPair.hotspot.x + sortPair.figure.displayBox().width + n7, sortPair2.hotspot.y);
                                    break;
                                }
                                case 7: {
                                    point = new Point(sortPair2.hotspot.x, sortPair.hotspot.y + sortPair.figure.displayBox().height + n8);
                                    break;
                                }
                                case 9: {
                                    point = new Point(sortPair.hotspot.x + (n2 >= 0 ? sortPair.figure.displayBox().width : sortPair2.figure.displayBox().width) + n7, sortPair.hotspot.y + (n3 >= 0 ? sortPair.figure.displayBox().height : sortPair2.figure.displayBox().height) + n8);
                                }
                            }
                            break;
                        }
                        point = sortPair2.hotspot;
                    }
                }
                if (point != null) {
                    sortPair2.figure.moveBy(point.x - sortPair2.hotspot.x, point.y - sortPair2.hotspot.y);
                    sortPair = new SortPair(this.fOp, sortPair2.figure);
                }
                ++n5;
            }
            drawingView.checkDamage();
            return true;
        }
        return false;
    }

    private class ConnectionFilter
    implements FigureFilter {
        private ConnectionFilter() {
        }

        @Override
        public boolean isUsed(Figure figure) {
            return !(figure instanceof ConnectionFigure);
        }
    }

    private class SortPair {
        public final Figure figure;
        public final Point hotspot;

        public SortPair(int n, Figure figure) {
            Point point = null;
            switch (n) {
                case 0: 
                case 3: 
                case 6: 
                case 7: {
                    point = figure.displayBox().getLocation();
                    break;
                }
                case 2: 
                case 5: {
                    point = new Point(figure.displayBox().x + figure.displayBox().width, figure.displayBox().y + figure.displayBox().height);
                    break;
                }
                case 1: 
                case 4: 
                case 8: {
                    point = Geom.center(figure.displayBox());
                }
            }
            this.figure = figure;
            this.hotspot = point;
        }

        public long distance2(Point point) {
            return Geom.length2(point.x, point.y, this.hotspot.x, this.hotspot.y);
        }
    }

    private class HotspotComparator
    implements Comparator<SortPair> {
        private int fOp;

        public HotspotComparator(int n) {
            this.fOp = n;
        }

        @Override
        public int compare(SortPair sortPair, SortPair sortPair2) {
            SortPair sortPair3 = sortPair;
            SortPair sortPair4 = sortPair2;
            switch (this.fOp) {
                case 0: 
                case 1: 
                case 2: 
                case 6: {
                    return sortPair3.hotspot.x - sortPair4.hotspot.x;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    return sortPair3.hotspot.y - sortPair4.hotspot.y;
                }
            }
            throw new RuntimeException("SpreadCommand: Comparator: Illegal operation mode " + this.fOp + "!");
        }
    }

    private class DistanceComparator
    implements Comparator<SortPair> {
        private Point origin;

        public DistanceComparator(Point point) {
            this.origin = point;
        }

        @Override
        public int compare(SortPair sortPair, SortPair sortPair2) {
            SortPair sortPair3 = sortPair;
            SortPair sortPair4 = sortPair2;
            long l = sortPair4.distance2(this.origin) - sortPair3.distance2(this.origin);
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private class ProjectionComparator
    implements Comparator<SortPair> {
        private float xl;
        private float yl;
        private float denominator;

        public ProjectionComparator(Point point, Point point2) throws ArithmeticException {
            float f = (float)Math.sqrt(Geom.length2(point.x, point.y, point2.x, point2.y));
            if (f == 0.0f) {
                throw new ArithmeticException("Projection line end points are too near!");
            }
            this.xl = (float)(point2.x - point.x) / f;
            this.yl = (float)(point2.y - point.y) / f;
            this.denominator = this.xl * this.xl + this.yl * this.yl;
        }

        @Override
        public int compare(SortPair sortPair, SortPair sortPair2) {
            SortPair sortPair3 = sortPair;
            SortPair sortPair4 = sortPair2;
            float f = (float)sortPair3.hotspot.x * this.xl + (float)sortPair3.hotspot.y * this.yl / this.denominator;
            float f2 = (float)sortPair4.hotspot.x * this.xl + (float)sortPair4.hotspot.y * this.yl / this.denominator;
            if (f > f2) {
                return 1;
            }
            if (f < f2) {
                return -1;
            }
            return 0;
        }
    }
}

