/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.NullDrawingEditor;
import java.awt.Color;

public class AlphaChangeCommand
extends UndoableCommand {
    private String fAttribute;
    private int fValue;

    public AlphaChangeCommand(String string, String string2, int n) {
        super(string);
        this.fAttribute = string2;
        this.fValue = n;
    }

    @Override
    protected boolean executeUndoable() {
        DrawingView drawingView = this.getEditor().view();
        FigureEnumeration figureEnumeration = drawingView.selectionElements();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Object object = figure.getAttribute(this.fAttribute);
            if (!(object instanceof Color)) continue;
            Color color = (Color)object;
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.fValue);
            figure.setAttribute(this.fAttribute, color);
        }
        drawingView.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }
}

