/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.application.AbstractFileDragDropListener;
import CH.ifa.draw.application.DrawingViewFrame;
import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.figures.ImageFigureCreationTool;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.io.ImageFileFilter;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileFilter;
import java.util.Vector;

public class ImageFigureCreationDragDropListener
extends AbstractFileDragDropListener {
    private DrawingViewFrame drawingViewFrame;

    public ImageFigureCreationDragDropListener(DrawingViewFrame drawingViewFrame) {
        this.drawingViewFrame = drawingViewFrame;
    }

    @Override
    protected FileFilter getFileFilter() {
        return new ImageFileFilter();
    }

    @Override
    protected void handleFiles(File[] fileArray, Point point) {
        if (fileArray.length >= 1) {
            Vector<Figure> vector = new Vector<Figure>();
            DrawingView drawingView = this.drawingViewFrame.view();
            for (File file : fileArray) {
                Image image = ImageFigureCreationTool.createImage(file.getAbsolutePath(), this.drawingViewFrame);
                ImageFigure imageFigure = new ImageFigure(image, file.getAbsolutePath(), point);
                Rectangle rectangle = imageFigure.displayBox();
                imageFigure.moveBy(-(rectangle.width / 2), -(rectangle.height / 2));
                vector.add(imageFigure);
            }
            drawingView.addAll(vector);
            drawingView.checkDamage();
        }
    }
}

