/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ChopEllipseConnector;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.util.Vector;

public class EllipseFigure
extends AttributeFigure {
    private static final long serialVersionUID = -6856203289355118951L;
    private Rectangle fDisplayBox;
    private int ellipseFigureSerializedDataVersion = 1;

    public EllipseFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    public EllipseFigure(Point point, Point point2) {
        this.basicDisplayBox(point, point2);
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        BoxHandleKit.addHandles(this, vector);
        return vector;
    }

    @Override
    public void basicDisplayBox(Point point, Point point2) {
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    @Override
    public boolean containsPoint(int n, int n2) {
        if (super.containsPoint(n, n2)) {
            return Geom.ellipseContainsPoint(this.displayBox(), n, n2);
        }
        return false;
    }

    @Override
    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
    }

    @Override
    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Ellipse2D.Double double_ = new Ellipse2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.fill(double_);
    }

    @Override
    public void drawFrame(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Ellipse2D.Double double_ = new Ellipse2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.draw(double_);
    }

    @Override
    public Insets connectionInsets() {
        Rectangle rectangle = this.fDisplayBox;
        int n = rectangle.width / 2;
        int n2 = rectangle.height / 2;
        return new Insets(n2, n, n2, n);
    }

    @Override
    public Connector connectorAt(int n, int n2) {
        return new ChopEllipseConnector(this);
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fDisplayBox = new Rectangle(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
    }
}

