/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.GroupHandle;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CompositeAttributeFigure
extends AttributeFigure
implements FigureChangeListener {
    public static Logger logger = Logger.getLogger(CompositeAttributeFigure.class);
    protected Vector<Figure> attached = new Vector();
    protected boolean removeWhenEmpty = true;

    public CompositeAttributeFigure() {
        this.setFillColor(ColorMap.NONE);
        this.setFrameColor(ColorMap.NONE);
    }

    @Override
    public boolean includes(Figure figure) {
        return this.getAttached().contains(figure);
    }

    @Override
    public void drawFrame(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.draw(float_);
    }

    @Override
    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.fill(float_);
    }

    @Override
    protected void basicMoveBy(int n, int n2) {
        DrawingView drawingView = this.getView();
        if (drawingView == null) {
            return;
        }
        for (Figure iterator : this.attached) {
            iterator.removeFigureChangeListener(this);
        }
        Vector<Figure> vector = drawingView.selection();
        for (Figure figure : this.attached) {
            if (vector.contains(figure)) continue;
            figure.moveBy(n, n2);
        }
        for (Figure figure : this.attached) {
            figure.addFigureChangeListener(this);
        }
    }

    @Override
    public void basicDisplayBox(Point point, Point point2) {
    }

    @Override
    public Rectangle displayBox() {
        Enumeration<Figure> enumeration = this.attached.elements();
        Rectangle rectangle = new Rectangle();
        if (enumeration.hasMoreElements()) {
            rectangle = enumeration.nextElement().displayBox();
        }
        while (enumeration.hasMoreElements()) {
            rectangle.add(enumeration.nextElement().displayBox());
        }
        if (rectangle == null) {
            return new Rectangle(0, 0);
        }
        return rectangle;
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        vector.addElement(new GroupHandle(this, RelativeLocator.northWest()));
        vector.addElement(new GroupHandle(this, RelativeLocator.northEast()));
        vector.addElement(new GroupHandle(this, RelativeLocator.southWest()));
        vector.addElement(new GroupHandle(this, RelativeLocator.southEast()));
        return vector;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    protected DrawingView getView() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        if (drawApplication == null) {
            return null;
        }
        return drawApplication.getView(drawApplication.drawing());
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.attached.size());
        for (Figure figure : this.attached) {
            storableOutput.writeStorable(figure);
        }
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        if (storableInput.getVersion() > 9) {
            super.read(storableInput);
        }
        this.attached = new Vector();
        int n = storableInput.readInt();
        if (n != 0) {
            for (int i = 1; i <= n; ++i) {
                Figure figure = (Figure)storableInput.readStorable();
                this.attached.add(figure);
                figure.addFigureChangeListener(this);
            }
        }
        Enumeration<String> enumeration = this.getAttributeKeys();
        boolean bl = false;
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (string.equals("FillColor")) {
                bl = true;
            }
            if (!string.equals("FrameColor")) continue;
            bl2 = true;
        }
        if (!bl) {
            this.setFillColor(ColorMap.NONE);
        }
        if (!bl2) {
            this.setFrameColor(ColorMap.NONE);
            this.setAttribute("LineStyle", "1 2");
        }
    }

    public Vector<Figure> getAttached() {
        return this.attached;
    }

    @Override
    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (bl) {
            return super.inspect(drawingView, bl);
        }
        drawingView.clearSelection();
        drawingView.addToSelectionAll(this.attached);
        return true;
    }

    @Override
    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
        this.invalidate();
    }

    @Override
    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.changed();
    }

    @Override
    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        this.willChange();
        Figure figure = figureChangeEvent.getFigure();
        this.attached.remove(figure);
        if (this.removeWhenEmpty && this.attached.isEmpty() && this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
        this.changed();
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        this.willChange();
        this.attached.remove(figureChangeEvent.getSource());
        this.changed();
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
        System.out.println("NCF: figureRequestUpdate");
    }

    @Override
    public void figureHandlesChanged(FigureChangeEvent figureChangeEvent) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Enumeration<Figure> enumeration = this.attached.elements();
        while (enumeration.hasMoreElements()) {
            Figure figure = enumeration.nextElement();
            figure.addToContainer(this);
        }
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        return new MergedFigureEnumerator(super.getFiguresWithDependencies(), this.getAttachedFigures());
    }

    private FigureEnumeration getAttachedFigures() {
        return new FigureEnumerator(this.attached);
    }

    public void updateListeners() {
        FigureEnumeration figureEnumeration = this.getFiguresWithDependencies();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.addToContainer(this);
        }
    }
}

