/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import jline.console.ConsoleReader;
import org.apache.log4j.Logger;

public class LoadCommand
implements CLCommand {
    public static Logger logger = Logger.getLogger(LoadCommand.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(String[] stringArray, PrintStream printStream) {
        Object object;
        if (stringArray.length != 1 || "h".equals(stringArray[0]) || "-h".equals(stringArray[0]) || "--help".equals(stringArray[0]) || "--h".equals(stringArray[0]) || "-help".equals(stringArray[0])) {
            printStream.println("usage: load <url>\nexamples: \nload file:/path/to/location/name/plugin.cfg\nload file:/path/to/location/pluginname.jar\nload pluginname.jar\nload pluginname*");
            return;
        }
        Object object2 = null;
        File file = null;
        String string = stringArray[0];
        printStream.println("\n\n------- LOAD -------\n\n");
        if (!string.endsWith("*")) {
            try {
                object = new URL(string);
                file = LoadCommand.getFile((URL)object);
                if (file == null) {
                    object2 = object;
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(LoadCommand.class.getSimpleName() + ": Ignoring exception: " + String.valueOf(malformedURLException)));
                }
                file = new File(string);
            }
        }
        if (object2 != null) {
            if (LoadCommand.isLoaded(object2, printStream)) {
                object2 = null;
            }
        } else {
            try {
                if (file != null && file.isAbsolute() && file.exists()) {
                    if (!LoadCommand.isLoaded(file, printStream)) {
                        object2 = LoadCommand.createURL(file);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(LoadCommand.class.getSimpleName() + ": directly found URL: " + String.valueOf(object2)));
                        }
                    }
                } else {
                    File file2;
                    object = PluginProperties.getUserProperties().getProperty("pluginLocations");
                    ArrayList<File> arrayList = new ArrayList<File>();
                    if (object != null) {
                        String[] stringArray2 = ((String)object).split(File.pathSeparator);
                        for (String string2 : stringArray2) {
                            arrayList.add(new File(string2).getCanonicalFile());
                        }
                    }
                    if (!arrayList.contains(file2 = new File(new File(PluginManager.getLoaderLocation().toURI()), "plugins").getCanonicalFile())) {
                        arrayList.add(file2);
                    }
                    ArrayList arrayList2 = new ArrayList();
                    int n = 0;
                    for (File file3 : arrayList) {
                        Object object3;
                        logger.debug((Object)(LoadCommand.class.getSimpleName() + ": Plugin Location found: " + file3.getAbsolutePath()));
                        if (!file3.exists()) continue;
                        if (file != null) {
                            object3 = new File(file3, file.getPath());
                            if (!((File)object3).exists()) continue;
                            arrayList2.add(object3);
                            continue;
                        }
                        object3 = file3.listFiles();
                        if (object3 == null) continue;
                        for (int i = 0; i < ((Object)object3).length; ++i) {
                            if (!((File)object3[i]).isDirectory() && ((File)object3[i]).getName().toLowerCase().startsWith(string.toLowerCase().replace("*", ""))) {
                                logger.debug((Object)(LoadCommand.class.getSimpleName() + ": Adding file to mached plugin list: " + ((File)object3[i]).getAbsolutePath()));
                                if (!arrayList2.contains(object3[i])) {
                                    arrayList2.add(object3[i]);
                                }
                                n = Math.max(n, ((File)object3[i]).getAbsolutePath().length());
                            }
                            if (!((File)object3[i]).isDirectory() || !((File)object3[i]).getName().toLowerCase().startsWith(string.toLowerCase().replace("*", ""))) continue;
                            logger.debug((Object)(LoadCommand.class.getSimpleName() + ": Adding plugin.cfg file to mached directory plugin list: " + ((File)object3[i]).getAbsolutePath()));
                            File file4 = new File((File)object3[i], "plugin.cfg");
                            if (!arrayList2.contains(file4)) {
                                arrayList2.add(file4);
                            }
                            n = Math.max(n, ((File)object3[i]).getAbsolutePath().length());
                        }
                    }
                    if (arrayList2.size() > 1) {
                        int n2 = this.selectFile(printStream, arrayList2, stringArray[0], n);
                        if (n2 < 0) return;
                        object2 = LoadCommand.createURL((File)arrayList2.get(n2));
                    } else if (arrayList2.size() == 1) {
                        File file5 = (File)arrayList2.get(0);
                        if (!LoadCommand.isLoaded(file5, printStream)) {
                            object2 = LoadCommand.createURL(file5);
                        }
                    } else {
                        printStream.println("No match found for " + stringArray[0] + ".");
                    }
                }
            }
            catch (Exception exception) {
                printStream.println("load failed: " + String.valueOf(exception));
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                object2 = null;
            }
        }
        if (object2 == null) {
            printStream.println("Stop command 'load " + stringArray[0] + "'.");
            return;
        }
        logger.debug((Object)(LoadCommand.class.getSimpleName() + ": Trying to load plugin from URL: " + String.valueOf(object2)));
        object = PluginManager.getInstance().loadPlugin((URL)object2);
        if (object != null) {
            printStream.println("\nPlug-in: \t" + object.getName() + "\t successfully loaded.\n");
            return;
        } else {
            printStream.println("Plug-in (" + String.valueOf(object2) + ") not loaded. See log messages for details.");
        }
    }

    private static URL createURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    private static File getFile(URL uRL) {
        if ("file".equals(uRL.getProtocol())) {
            return new File(uRL.getFile());
        }
        return null;
    }

    private int selectFile(PrintStream printStream, ArrayList<File> arrayList, String string, int n) {
        Object object;
        String string2;
        Object object2;
        printStream.println("The following plug-ins were found for " + string + " : ");
        printStream.println("");
        Object object3 = "";
        for (int i = 0; ((String)object3).length() < n && i < 500; ++i) {
            object3 = (String)object3 + " ";
        }
        object3 = (String)object3 + "  ";
        String string3 = " Selection   Path " + (String)object3 + " Status ";
        printStream.println(string3);
        Object object4 = "";
        for (int i = 0; ((String)object4).length() < string3.length() && i < 500; ++i) {
            object4 = (String)object4 + "-";
        }
        printStream.println((String)object4);
        printStream.println("");
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = arrayList.get(i);
            string2 = ((File)object2).getAbsolutePath();
            object = LoadCommand.isLoaded(object2) ? "loaded" : "  --";
            Object object5 = "";
            int n2 = n - string2.length() + 4;
            for (int j = 0; ((String)object5).length() < n2 && j < 100; ++j) {
                object5 = (String)object5 + " ";
            }
            object5 = (String)object5 + "  ";
            printStream.println(" " + (i + 1) + "           " + string2 + " " + (String)object5 + " " + (String)object);
        }
        printStream.println("");
        printStream.print("Press enter to stop loading plug-in, or type selection number: ");
        String string4 = null;
        object2 = "Stop  command 'load " + string + "'.";
        try {
            string2 = new ConsoleReader();
            string4 = string2.readLine();
        }
        catch (IOException iOException) {
            printStream.println("Could not load selected plug-in due to exception : " + String.valueOf(iOException) + ".");
            printStream.println((String)object2);
            return -1;
        }
        if (string4 != null && string4.trim().length() > 0) {
            string4 = string4.trim();
            try {
                int n3 = Integer.parseInt(string4) - 1;
                if (n3 < 0 || n3 >= arrayList.size()) {
                    printStream.println("Selection " + string4 + " not known.");
                    printStream.println((String)object2);
                    return -1;
                }
                object = arrayList.get(n3);
                if (object == null) {
                    printStream.println("Selection " + n3 + " not known");
                    printStream.println((String)object2);
                    return -1;
                }
                if (LoadCommand.isLoaded(object, printStream)) {
                    printStream.println((String)object2);
                    return -1;
                }
                return n3;
            }
            catch (Exception exception) {
                printStream.println("Selection " + string4 + " not known.");
                printStream.println((String)object2);
                return -1;
            }
        }
        printStream.println("No selection made.");
        printStream.println((String)object2);
        return -1;
    }

    private static boolean isLoaded(Object object) {
        return LoadCommand.getPlugin(object) != null;
    }

    private static boolean isLoaded(Object object, PrintStream printStream) {
        String string;
        IPlugin iPlugin = LoadCommand.getPlugin(object);
        if (object instanceof File) {
            File file = (File)object;
            string = file.getName();
            if ("plugin.cfg".equals(string)) {
                string = file.getParentFile().getName();
            }
        } else {
            string = object.toString();
        }
        if (iPlugin != null) {
            printStream.println("\n\tPlug-in \t" + iPlugin.getName() + " [" + string + "]\t already loaded.\n");
            return true;
        }
        return false;
    }

    private static IPlugin getPlugin(Object object) {
        if (object instanceof File) {
            return LoadCommand.getPlugin((File)object);
        }
        if (object instanceof URL) {
            return LoadCommand.getPlugin((URL)object);
        }
        throw new IllegalArgumentException(String.valueOf(object) + " is neither a " + File.class.getSimpleName() + " nor a " + URL.class.getSimpleName() + " instance.");
    }

    private static IPlugin getPlugin(File file) {
        block5: {
            try {
                File file2 = file.getCanonicalFile();
                for (IPlugin iPlugin : PluginManager.getInstance().getPlugins()) {
                    try {
                        File file3;
                        File file4 = LoadCommand.getFile(iPlugin.getProperties().getURL());
                        if (file4 == null || !file2.equals(file3 = file4.getCanonicalFile()) && (!file2.equals(file3.getParentFile()) || !file3.isFile()) && (!file3.equals(file2.getParentFile()) || !file2.isFile())) continue;
                        return iPlugin;
                    }
                    catch (IOException iOException) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)(LoadCommand.class.getSimpleName() + ": Ignoring exception while comparing the given file with " + iPlugin.getProperties().getURL().getFile() + ": " + String.valueOf(iOException)));
                    }
                }
            }
            catch (IOException iOException) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)(LoadCommand.class.getSimpleName() + ": Aborting the comparison of " + String.valueOf(file) + " with the plug-in URLs because of: " + String.valueOf(iOException)));
            }
        }
        return null;
    }

    private static IPlugin getPlugin(URL uRL) {
        for (IPlugin iPlugin : PluginManager.getInstance().getPlugins()) {
            if (!uRL.sameFile(iPlugin.getProperties().getURL())) continue;
            return iPlugin;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Load a new plug-in. Type 'load -help' to get examples of usage.";
    }

    @Override
    public String getArguments() {
        return "locationNames";
    }
}

