/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.shadow.ShadowInscribable;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNode;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class ShadowConnection
extends ShadowInscribable {
    public boolean trace;
    public ShadowNode from;
    public ShadowNode to;

    protected ShadowConnection(ShadowNode shadowNode, ShadowNode shadowNode2) {
        super(ShadowConnection.ensureIdentity(shadowNode, shadowNode2));
        this.from = shadowNode;
        this.to = shadowNode2;
        shadowNode.add(this);
        shadowNode2.add(this);
    }

    private static ShadowNet ensureIdentity(ShadowNode shadowNode, ShadowNode shadowNode2) {
        ShadowNet shadowNet;
        if (shadowNode == null | shadowNode2 == null) {
            throw new RuntimeException("Connection must be connected at both ends.");
        }
        ShadowNet shadowNet2 = shadowNet = shadowNode != null ? shadowNode.getNet() : null;
        if (shadowNode2 != null && shadowNet != shadowNode2.getNet()) {
            throw new RuntimeException("Must connect within one net.");
        }
        return shadowNet;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void setTrace(boolean bl) {
        if (this.trace != bl) {
            this.trace = bl;
        }
    }

    @Override
    public void discard() {
        this.from.remove(this);
        this.to.remove(this);
        super.discard();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.from.add(this);
        this.to.add(this);
    }
}

