/*
 * Decompiled with CFR 0.152.
 */
package de.renew.imagenetdiff;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import de.renew.imagenetdiff.EPSDiffClCommand;
import de.renew.imagenetdiff.EPSDiffCommand;
import de.renew.imagenetdiff.ImageNetDiffClCommand;
import de.renew.imagenetdiff.PNGDiffCommand;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import java.net.URL;
import javax.swing.JMenuItem;

public class ImageNetDiffPlugin
extends PluginAdapter {
    private CommandMenu _menu;
    private int blockcounter;

    public ImageNetDiffPlugin(URL uRL) throws PluginException {
        super(uRL);
    }

    public ImageNetDiffPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
    }

    public void init() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        if (drawPlugin == null) {
            return;
        }
        PluginManager pluginManager = PluginManager.getInstance();
        pluginManager.addCLCommand("diff", (CLCommand)new ImageNetDiffClCommand());
        pluginManager.addCLCommand("epsdiff", (CLCommand)new EPSDiffClCommand());
        MenuManager menuManager = drawPlugin.getMenuManager();
        this._menu = new CommandMenu("Net Diff");
        this._menu.putClientProperty((Object)"ch.ifa.draw.menu.id", (Object)"de.renew.imagenetdiff");
        this._menu.add((Command)new PNGDiffCommand());
        this._menu.add((Command)new EPSDiffCommand());
        this._menu.add((Command)new VersionInfoCommand((IPlugin)this));
        menuManager.registerMenu("Tools", (JMenuItem)this._menu);
    }

    public boolean cleanup() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        if (drawPlugin == null) {
            return true;
        }
        MenuManager menuManager = drawPlugin.getMenuManager();
        if (menuManager != null && this._menu != null) {
            menuManager.unregisterMenu((JMenuItem)this._menu);
        }
        PluginManager pluginManager = PluginManager.getInstance();
        pluginManager.removeCLCommand("diff");
        pluginManager.removeCLCommand("epsdiff");
        return true;
    }

    public synchronized boolean canShutDown() {
        return true;
    }

    public void addBlock() {
        if (this.blockcounter++ == 0) {
            PluginManager pluginManager = PluginManager.getInstance();
            pluginManager.blockExit((IPlugin)this);
        }
    }

    public void removeBlock() {
        if (--this.blockcounter <= 0) {
            PluginManager pluginManager = PluginManager.getInstance();
            pluginManager.exitOk((IPlugin)this);
            this.blockcounter = 0;
        }
    }
}

