/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.gui.ConfigureSimulationTabController;
import de.renew.gui.GuiPlugin;
import de.renew.gui.ModeReplacement;
import de.renew.gui.logging.ConfigureLoggingController;
import de.renew.gui.logging.GuiAppender;
import de.renew.gui.logging.LoggingController;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JMenuItem;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class LoggingGuiPlugin
extends PluginAdapter {
    public static Logger logger = Logger.getLogger(LoggingGuiPlugin.class);
    private static final Set<LoggingController> _LoggingFrameControllers = new HashSet<LoggingController>();
    private CommandMenuItem menu;
    private ConfigureLoggingController configTab;

    public LoggingGuiPlugin(URL uRL) throws PluginException {
        super(uRL);
    }

    public LoggingGuiPlugin(PluginProperties pluginProperties) throws PluginException {
        super(pluginProperties);
    }

    public void init() {
        logger.debug((Object)"initializing Logging GUI plugin.");
        this.configTab = new ConfigureLoggingController();
        GuiPlugin.getCurrent().addConfigTabController((ConfigureSimulationTabController)this.configTab);
        this.menu = new CommandMenuItem(new Command("show simulation trace"){

            public boolean isExecutable() {
                if (!super.isExecutable()) {
                    return false;
                }
                return ModeReplacement.getInstance().getSimulation().isSimulationActive();
            }

            public void execute() {
                new LoggingController(_LoggingFrameControllers);
            }
        }, 76);
        MenuManager menuManager = MenuManager.getInstance();
        MenuManager.SeparatorFactory separatorFactory = new MenuManager.SeparatorFactory("de.renew.gui.logging");
        menuManager.registerMenu("Simulation", separatorFactory.createSeparator());
        menuManager.registerMenu("Simulation", (JMenuItem)this.menu, "de.renew.gui.logging.showTrace");
        Logger.getLogger((String)"simulation").addAppender((Appender)new GuiAppender());
    }

    public static LoggingGuiPlugin getCurrent() {
        for (IPlugin iPlugin : PluginManager.getInstance().getPluginsProviding("de.renew.logging")) {
            if (!(iPlugin instanceof LoggingGuiPlugin)) continue;
            return (LoggingGuiPlugin)iPlugin;
        }
        return null;
    }

    public boolean cleanup() {
        for (LoggingController loggingController : _LoggingFrameControllers) {
            loggingController.closeFrame();
        }
        DrawPlugin.getCurrent().getMenuManager().unregisterMenu((JMenuItem)this.menu);
        GuiPlugin.getCurrent().removeConfigTabController((ConfigureSimulationTabController)this.configTab);
        return true;
    }

    public void closedLoggingFrame(LoggingController loggingController) {
        _LoggingFrameControllers.remove(loggingController);
    }
}

