/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ChopPieConnector;
import CH.ifa.draw.figures.PieAngleHandle;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.io.IOException;
import java.util.Vector;

public class PieFigure
extends AttributeFigure {
    static final int START_ANGLE = 1;
    static final int END_ANGLE = 2;
    private Rectangle fDisplayBox;
    private double startAngle;
    private double endAngle;

    public PieFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    public PieFigure(Point point, Point point2) {
        this(point, point2, 180.0, 90.0);
    }

    public PieFigure(Point point, Point point2, double d, double d2) {
        this.basicDisplayBox(point, point2);
        this.setStartAngle(d);
        this.setEndAngle(d2);
    }

    public void setStartAngle(double d) {
        this.startAngle = PieFigure.normalizeAngle(d);
        this.changed();
    }

    public void setEndAngle(double d) {
        this.endAngle = PieFigure.normalizeAngle(d);
        this.changed();
    }

    public void setAngle(int n, double d) {
        switch (n) {
            case 1: {
                this.setStartAngle(d);
                break;
            }
            case 2: {
                this.setEndAngle(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Undefined angle kind: " + n);
            }
        }
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public double getAngle(int n) {
        switch (n) {
            case 1: {
                return this.startAngle;
            }
            case 2: {
                return this.endAngle;
            }
        }
        throw new IllegalArgumentException("Undefined angle kind: " + n);
    }

    static double normalizeAngle(double d) {
        return (360.0 + d % 360.0) % 360.0;
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        vector.add(new PieAngleHandle(this, 1));
        vector.add(new PieAngleHandle(this, 2));
        BoxHandleKit.addHandles(this, vector);
        return vector;
    }

    @Override
    public void basicDisplayBox(Point point, Point point2) {
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    @Override
    public boolean containsPoint(int n, int n2) {
        if (super.containsPoint(n, n2)) {
            return Geom.ellipseContainsPoint(this.displayBox(), n, n2);
        }
        return false;
    }

    @Override
    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
    }

    @Override
    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = 2;
        double d = this.endAngle - this.startAngle;
        if (d < 0.0) {
            d += 360.0;
        }
        Arc2D.Double double_ = new Arc2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.startAngle, d, n);
        graphics2D.fill(double_);
    }

    @Override
    public void drawFrame(Graphics graphics) {
        double d;
        Rectangle rectangle = this.displayBox();
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = 2;
        if (ColorMap.isTransparent(this.getFillColor())) {
            n = 0;
        }
        if ((d = this.endAngle - this.startAngle) < 0.0) {
            d += 360.0;
        }
        Arc2D.Double double_ = new Arc2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.startAngle, d, n);
        graphics2D.draw(double_);
    }

    @Override
    public Insets connectionInsets() {
        Rectangle rectangle = this.fDisplayBox;
        int n = rectangle.width / 2;
        int n2 = rectangle.height / 2;
        return new Insets(n2, n, n2, n);
    }

    @Override
    public Connector connectorAt(int n, int n2) {
        return new ChopPieConnector(this);
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
        storableOutput.writeDouble(this.startAngle);
        storableOutput.writeDouble(this.endAngle);
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fDisplayBox = new Rectangle(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
        this.startAngle = storableInput.readDouble();
        this.endAngle = storableInput.readDouble();
    }
}

