/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ElbowHandle;
import CH.ifa.draw.figures.ElbowTextLocator;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class ElbowConnection
extends LineConnection {
    private static final long serialVersionUID = 2193968743082078559L;
    private int elbowConnectionSerializedDataVersion = 1;

    @Override
    public void updateConnection() {
        super.updateConnection();
        this.updatePoints();
    }

    @Override
    public void layoutConnection() {
    }

    @Override
    public Vector<Handle> handles() {
        int n;
        Vector<Handle> vector = new Vector<Handle>(this.fPoints.size() * 2);
        vector.addElement(new ChangeConnectionStartHandle(this));
        for (n = 1; n < this.fPoints.size() - 1; ++n) {
            vector.addElement(new NullHandle(this, ElbowConnection.locator(n)));
        }
        vector.addElement(new ChangeConnectionEndHandle(this));
        for (n = 0; n < this.fPoints.size() - 1; ++n) {
            vector.addElement(new ElbowHandle(this, n));
        }
        return vector;
    }

    @Override
    public Locator connectedTextLocator(Figure figure) {
        return new ElbowTextLocator();
    }

    protected void updatePoints() {
        this.willChange();
        Point point = this.startPoint();
        Point point2 = this.endPoint();
        this.fPoints.removeAllElements();
        this.fPoints.addElement(point);
        if (point.x == point2.x || point.y == point2.y) {
            this.fPoints.addElement(point2);
        } else {
            Rectangle rectangle = this.start().owner().displayBox();
            Rectangle rectangle2 = this.end().owner().displayBox();
            int n = Geom.direction(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2, rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2);
            if (n == 1 || n == 2) {
                this.fPoints.addElement(new Point(point.x, (point.y + point2.y) / 2));
                this.fPoints.addElement(new Point(point2.x, (point.y + point2.y) / 2));
            } else {
                this.fPoints.addElement(new Point((point.x + point2.x) / 2, point.y));
                this.fPoints.addElement(new Point((point.x + point2.x) / 2, point2.y));
            }
            this.fPoints.addElement(point2);
        }
        this.changed();
    }
}

