/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.util.Command;
import java.util.Enumeration;

public class SaveAllDrawingsCommand
extends Command {
    public SaveAllDrawingsCommand() {
        super("Save All Drawings");
    }

    @Override
    public final boolean isExecutable() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        if (drawApplication == null) {
            return false;
        }
        return drawApplication.drawings().hasMoreElements();
    }

    @Override
    public final void execute() {
        Drawing drawing;
        DrawApplication drawApplication = DrawPlugin.getGui();
        Enumeration<Drawing> enumeration = drawApplication.drawings();
        while (enumeration.hasMoreElements()) {
            drawing = enumeration.nextElement();
            if (!drawing.isStorable() || drawing.getFilename() != null) continue;
            drawApplication.showDrawingViewContainer(drawing);
            if (drawApplication.promptSaveAs(drawing)) continue;
            return;
        }
        enumeration = drawApplication.drawings();
        while (enumeration.hasMoreElements()) {
            drawing = enumeration.nextElement();
            if (!drawing.isStorable()) continue;
            drawApplication.saveDrawing(drawing);
        }
    }
}

