/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamevariable;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.DeclarationFinder;
import de.renew.refactoring.parse.VariableParser;
import de.renew.refactoring.renamevariable.NoVariableSelectedException;
import de.renew.refactoring.renamevariable.RenameVariableEditor;
import de.renew.refactoring.renamevariable.RenameVariableReferenceFinder;
import de.renew.refactoring.renamevariable.RenameVariableSelectionChecker;
import de.renew.refactoring.renamevariable.Variable;
import de.renew.refactoring.renamevariable.VariableNameMatch;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

class RenameVariableRefactoring {
    private static Logger logger = Logger.getLogger(RenameVariableRefactoring.class);
    private final VariableParser _parser;
    private final Drawing _drawing;
    private final CPNTextFigure _selectedTextFigure;
    private Variable _selectedVariable;
    private List<VariableNameMatch> _references;
    private String _newName;
    private RenameVariableEditor _editor;
    private Set<Variable> _variablesInSelection;

    RenameVariableRefactoring(VariableParser variableParser, Drawing drawing, List<Figure> list) throws NoVariableSelectedException {
        this._parser = variableParser;
        this._drawing = drawing;
        this._selectedTextFigure = RenameVariableRefactoring.findSelectedTextFigure(variableParser, drawing, list);
        this._variablesInSelection = this.findVariablesInSelection();
        if (this._variablesInSelection.size() == 0) {
            throw new NoVariableSelectedException();
        }
    }

    Set<Variable> getVariablesInSelection() {
        return this._variablesInSelection;
    }

    private Set<Variable> findVariablesInSelection() {
        List<StringMatch> list = this._selectedTextFigure instanceof DeclarationFigure ? this._parser.findVariablesInDeclarationNode() : this._parser.findVariables(this._selectedTextFigure.getText());
        HashSet<Variable> hashSet = new HashSet<Variable>();
        for (StringMatch stringMatch : list) {
            String string = stringMatch.match();
            hashSet.add(new Variable(string, this._parser.findVariableType(string)));
        }
        return hashSet;
    }

    void findReferences() {
        assert (this._selectedVariable != null);
        this._references = (List)new RenameVariableReferenceFinder(this._parser, this._drawing, this._selectedVariable.getName()).searchNextItem();
    }

    CPNTextFigure getSelectedTextFigure() {
        return this._selectedTextFigure;
    }

    Variable getSelectedVariable() {
        return this._selectedVariable;
    }

    String getSelectedVariableName() {
        return this._selectedVariable.getName();
    }

    void setSelectedVariable(Variable variable) {
        this._selectedVariable = variable;
    }

    List<VariableNameMatch> getReferences() {
        return Collections.unmodifiableList(this._references);
    }

    StringMatch getSelectedVariableStringMatch() {
        String string = this._selectedTextFigure.getText();
        List<StringMatch> list = this._selectedTextFigure instanceof DeclarationFigure ? this._parser.findVariablesInDeclarationNode() : this._parser.findVariables(string);
        for (StringMatch stringMatch : list) {
            if (!stringMatch.match().equals(this.getSelectedVariableName())) continue;
            return stringMatch;
        }
        return null;
    }

    void replaceVariables() {
        if (this._references == null) {
            this.findReferences();
        }
        this._editor = new RenameVariableEditor(this._references, this._newName);
        this._editor.performAllEdits();
    }

    String getNewName() {
        return this._newName;
    }

    void setNewName(String string) {
        this._newName = string;
        logger.debug((Object)("new name: " + string));
    }

    boolean enteredValidVariableName() {
        if (this._newName.equals(this.getSelectedVariableName())) {
            return true;
        }
        return this._parser.isValidVariableName(this._newName);
    }

    void restorePreviousTexts() {
        if (this._editor == null) {
            return;
        }
        this._editor.restorePreviousTexts();
    }

    private static CPNTextFigure findSelectedTextFigure(VariableParser variableParser, Drawing drawing, List<Figure> list) {
        RenameVariableSelectionChecker renameVariableSelectionChecker = new RenameVariableSelectionChecker(list, variableParser);
        if (renameVariableSelectionChecker.isTextFigureWithVariableSelected()) {
            return (CPNTextFigure)list.get(0);
        }
        return new DeclarationFinder(drawing).declarationFigure();
    }
}

