/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportcli;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import CH.ifa.draw.util.GUIProperties;
import de.renew.io.exportFormats.EPSExportFormat;
import de.renew.io.exportFormats.PDFExportFormat;
import de.renew.io.exportFormats.PNGExportFormat;
import de.renew.io.exportFormats.SVGExportFormat;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class Export {
    public static List<ExportFormat> exportFormats = Arrays.asList(new ExportFormat[]{new PDFExportFormat(), new PNGExportFormat(), new EPSExportFormat()});

    public static void main(String[] stringArray) throws Exception {
        PluginManager.configureLogging();
        GUIProperties.setProperties((Properties)PluginProperties.getUserProperties());
        if (stringArray.length >= 2) {
            File file;
            File file2;
            String string = stringArray[0];
            Object object = stringArray[1];
            File file3 = new File(string);
            Drawing drawing = DrawingFileHelper.loadDrawing((File)file3, System.out::println);
            Object object2 = Export.guessExportFormat((String)object);
            if (object2 == null) {
                object2 = new PDFExportFormat();
                object = (String)object + ".pdf";
            }
            if ((file2 = (file = new File((String)object)).getParentFile()) != null && !file2.exists()) {
                System.out.println("Creating directory " + String.valueOf(file2) + " because it does not exist.");
                file.getParentFile().mkdirs();
            }
            System.out.println("Exporting " + file3.getAbsolutePath() + " to " + file.getAbsolutePath() + ".");
            object2.export(drawing, file);
        }
    }

    private static ExportFormat guessExportFormat(String string) {
        String string2 = Export.getFileExtension(string);
        ExportFormatAbstract exportFormatAbstract = null;
        switch (string2.toLowerCase()) {
            case "pdf": {
                exportFormatAbstract = new PDFExportFormat();
                break;
            }
            case "eps": {
                exportFormatAbstract = new EPSExportFormat();
                break;
            }
            case "png": {
                exportFormatAbstract = new PNGExportFormat();
                break;
            }
            case "svg": {
                exportFormatAbstract = new SVGExportFormat();
            }
        }
        return exportFormatAbstract;
    }

    private static String getFileExtension(String string) {
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }
}

