/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.TextHolder;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingLoader;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.FigureCreator;
import de.renew.gui.ModeReplacement;
import de.renew.net.NetInstance;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.ObjectAccessor;
import java.rmi.RemoteException;

class NetInstanceFigureCreator
implements FigureCreator {
    NetInstanceFigureCreator() {
    }

    @Override
    public Figure getTokenFigure(ObjectAccessor objectAccessor, boolean bl) throws RemoteException {
        NetInstanceAccessor netInstanceAccessor = objectAccessor.asNetInstance();
        CPNDrawing cPNDrawing = null;
        Figure figure = null;
        CPNDrawingLoader cPNDrawingLoader = ModeReplacement.getInstance().getDrawingLoader();
        if (cPNDrawingLoader != null) {
            cPNDrawing = cPNDrawingLoader.getDrawing(netInstanceAccessor.getNet().asString());
        }
        if (cPNDrawing != null) {
            figure = cPNDrawing.getIconFigure();
        }
        if (figure != null) {
            figure = (Figure)figure.clone();
            this.updateID(figure, netInstanceAccessor);
            return figure;
        }
        return null;
    }

    @Override
    public boolean canCreateFigure(ObjectAccessor objectAccessor, boolean bl) throws RemoteException {
        return objectAccessor != null && objectAccessor.isInstanceOf(NetInstance.class);
    }

    private void updateID(Figure figure, NetInstanceAccessor netInstanceAccessor) {
        if (figure instanceof TextHolder) {
            TextHolder textHolder = (TextHolder)figure;
            textHolder.setReadOnly(true);
            textHolder.setText(CPNInstanceDrawing.expandMacro(textHolder.getText(), netInstanceAccessor));
        } else if (figure instanceof CompositeFigure) {
            FigureEnumeration figureEnumeration = figure.figures();
            while (figureEnumeration.hasMoreElements()) {
                this.updateID(figureEnumeration.nextFigure(), netInstanceAccessor);
            }
        }
    }
}

