/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.FigureException;
import CH.ifa.draw.standard.TextHolder;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNSimulation;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.FigureExceptionFactory;
import de.renew.gui.GuiPlugin;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PlaceFigure;
import de.renew.gui.SemanticUpdateFigure;
import de.renew.gui.ShadowHolder;
import de.renew.gui.TransitionFigure;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import org.apache.log4j.Logger;

public class CPNTextTool
extends ConnectedTextTool {
    public static Logger logger = Logger.getLogger(CPNTextTool.class);
    private CPNTextFigure fTextFigure = null;
    private CPNDrawing fDrawing = null;

    public CPNTextTool(DrawingEditor drawingEditor, CPNTextFigure cPNTextFigure) {
        super(drawingEditor, (TextFigure)cPNTextFigure);
    }

    public CPNTextTool(DrawingEditor drawingEditor, CPNTextFigure cPNTextFigure, boolean bl) {
        super(drawingEditor, (TextFigure)cPNTextFigure, bl);
    }

    public void beginEdit(TextHolder textHolder) {
        super.beginEdit(textHolder);
        if (textHolder instanceof CPNTextFigure && this.fEditor.drawing() instanceof CPNDrawing) {
            this.fTextFigure = (CPNTextFigure)textHolder;
            this.fDrawing = (CPNDrawing)this.fEditor.drawing();
        } else {
            this.fTextFigure = null;
        }
    }

    public void endEdit() {
        super.endEdit();
        if (this.fTextFigure != null) {
            String string;
            boolean bl;
            CPNTextFigure cPNTextFigure = this.fTextFigure;
            this.fTextFigure = null;
            int n = cPNTextFigure.getType();
            boolean bl2 = bl = n == 3;
            if ((n == 1 || bl) && (string = cPNTextFigure.getText()).trim().length() > 0) {
                try {
                    CPNSimulation cPNSimulation = ModeReplacement.getInstance().getSimulation();
                    cPNSimulation.buildAllShadows();
                    ShadowNetSystem shadowNetSystem = cPNSimulation.getNetSystem();
                    ShadowHolder shadowHolder = (ShadowHolder)cPNTextFigure.parent();
                    ShadowNet shadowNet = this.fDrawing.buildShadow(shadowNetSystem);
                    if (cPNTextFigure instanceof SemanticUpdateFigure) {
                        ((SemanticUpdateFigure)((Object)cPNTextFigure)).semanticUpdate(shadowNet);
                    }
                    if (shadowNet != null) {
                        if (cPNTextFigure instanceof DeclarationFigure) {
                            this.fEditor.showStatus("Checking Declaration Node...");
                            shadowNet.checkDeclarationNode(string, bl);
                        } else if (shadowHolder != null && shadowNet != null) {
                            if (shadowHolder instanceof TransitionFigure) {
                                this.fEditor.showStatus("Checking Transition Inscription...");
                                shadowNet.checkTransitionInscription(string, bl);
                            } else if (shadowHolder instanceof PlaceFigure) {
                                this.fEditor.showStatus("Checking Place Inscription...");
                                shadowNet.checkPlaceInscription(string, bl);
                            } else if (shadowHolder instanceof ArcConnection) {
                                this.fEditor.showStatus("Checking Arc Inscription...");
                                shadowNet.checkArcInscription(string, bl);
                            }
                        }
                    }
                    GuiPlugin.getCurrent().closeSyntaxErrorFrame();
                }
                catch (SyntaxException syntaxException) {
                    this.fEditor.showStatus("A syntax error occured.");
                    FigureException figureException = FigureExceptionFactory.createFigureException(syntaxException);
                    if (figureException.errorDrawing == null) {
                        figureException = FigureExceptionFactory.createFigureException(syntaxException, this.fDrawing, cPNTextFigure);
                    }
                    logger.debug((Object)syntaxException.getMessage(), (Throwable)syntaxException);
                    GuiPlugin.getCurrent().processSyntaxException(figureException, false);
                }
            }
        }
    }
}

